/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backupsearch.model.BackupCreationTimeFilter;
import software.amazon.awssdk.services.backupsearch.model.RecoveryPointArnListCopier;
import software.amazon.awssdk.services.backupsearch.model.ResourceArnListCopier;
import software.amazon.awssdk.services.backupsearch.model.ResourceType;
import software.amazon.awssdk.services.backupsearch.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.backupsearch.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchScope> {
    private static final SdkField<List<String>> BACKUP_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupResourceTypes").getter(SearchScope.getter(SearchScope::backupResourceTypesAsStrings)).setter(SearchScope.setter(Builder::backupResourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BackupCreationTimeFilter> BACKUP_RESOURCE_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupResourceCreationTime").getter(SearchScope.getter(SearchScope::backupResourceCreationTime)).setter(SearchScope.setter(Builder::backupResourceCreationTime)).constructor(BackupCreationTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceCreationTime").build()}).build();
    private static final SdkField<List<String>> SOURCE_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceResourceArns").getter(SearchScope.getter(SearchScope::sourceResourceArns)).setter(SearchScope.setter(Builder::sourceResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BACKUP_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupResourceArns").getter(SearchScope.getter(SearchScope::backupResourceArns)).setter(SearchScope.setter(Builder::backupResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> BACKUP_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BackupResourceTags").getter(SearchScope.getter(SearchScope::backupResourceTags)).setter(SearchScope.setter(Builder::backupResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RESOURCE_TYPES_FIELD, BACKUP_RESOURCE_CREATION_TIME_FIELD, SOURCE_RESOURCE_ARNS_FIELD, BACKUP_RESOURCE_ARNS_FIELD, BACKUP_RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> backupResourceTypes;
    private final BackupCreationTimeFilter backupResourceCreationTime;
    private final List<String> sourceResourceArns;
    private final List<String> backupResourceArns;
    private final Map<String, String> backupResourceTags;

    private SearchScope(BuilderImpl builder) {
        this.backupResourceTypes = builder.backupResourceTypes;
        this.backupResourceCreationTime = builder.backupResourceCreationTime;
        this.sourceResourceArns = builder.sourceResourceArns;
        this.backupResourceArns = builder.backupResourceArns;
        this.backupResourceTags = builder.backupResourceTags;
    }

    public final List<ResourceType> backupResourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(this.backupResourceTypes);
    }

    public final boolean hasBackupResourceTypes() {
        return this.backupResourceTypes != null && !(this.backupResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> backupResourceTypesAsStrings() {
        return this.backupResourceTypes;
    }

    public final BackupCreationTimeFilter backupResourceCreationTime() {
        return this.backupResourceCreationTime;
    }

    public final boolean hasSourceResourceArns() {
        return this.sourceResourceArns != null && !(this.sourceResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> sourceResourceArns() {
        return this.sourceResourceArns;
    }

    public final boolean hasBackupResourceArns() {
        return this.backupResourceArns != null && !(this.backupResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> backupResourceArns() {
        return this.backupResourceArns;
    }

    public final boolean hasBackupResourceTags() {
        return this.backupResourceTags != null && !(this.backupResourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> backupResourceTags() {
        return this.backupResourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupResourceTypes() ? this.backupResourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupResourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceResourceArns() ? this.sourceResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupResourceArns() ? this.backupResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupResourceTags() ? this.backupResourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchScope)) {
            return false;
        }
        SearchScope other = (SearchScope)obj;
        return this.hasBackupResourceTypes() == other.hasBackupResourceTypes() && Objects.equals(this.backupResourceTypesAsStrings(), other.backupResourceTypesAsStrings()) && Objects.equals(this.backupResourceCreationTime(), other.backupResourceCreationTime()) && this.hasSourceResourceArns() == other.hasSourceResourceArns() && Objects.equals(this.sourceResourceArns(), other.sourceResourceArns()) && this.hasBackupResourceArns() == other.hasBackupResourceArns() && Objects.equals(this.backupResourceArns(), other.backupResourceArns()) && this.hasBackupResourceTags() == other.hasBackupResourceTags() && Objects.equals(this.backupResourceTags(), other.backupResourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"SearchScope").add("BackupResourceTypes", this.hasBackupResourceTypes() ? this.backupResourceTypesAsStrings() : null).add("BackupResourceCreationTime", (Object)this.backupResourceCreationTime()).add("SourceResourceArns", this.hasSourceResourceArns() ? this.sourceResourceArns() : null).add("BackupResourceArns", this.hasBackupResourceArns() ? this.backupResourceArns() : null).add("BackupResourceTags", this.hasBackupResourceTags() ? this.backupResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.backupResourceTypesAsStrings()));
            }
            case "BackupResourceCreationTime": {
                return Optional.ofNullable(clazz.cast(this.backupResourceCreationTime()));
            }
            case "SourceResourceArns": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArns()));
            }
            case "BackupResourceArns": {
                return Optional.ofNullable(clazz.cast(this.backupResourceArns()));
            }
            case "BackupResourceTags": {
                return Optional.ofNullable(clazz.cast(this.backupResourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupResourceTypes", BACKUP_RESOURCE_TYPES_FIELD);
        map.put("BackupResourceCreationTime", BACKUP_RESOURCE_CREATION_TIME_FIELD);
        map.put("SourceResourceArns", SOURCE_RESOURCE_ARNS_FIELD);
        map.put("BackupResourceArns", BACKUP_RESOURCE_ARNS_FIELD);
        map.put("BackupResourceTags", BACKUP_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchScope, T> g) {
        return obj -> g.apply((SearchScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> backupResourceTypes = DefaultSdkAutoConstructList.getInstance();
        private BackupCreationTimeFilter backupResourceCreationTime;
        private List<String> sourceResourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> backupResourceArns = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> backupResourceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchScope model) {
            this.backupResourceTypesWithStrings(model.backupResourceTypes);
            this.backupResourceCreationTime(model.backupResourceCreationTime);
            this.sourceResourceArns(model.sourceResourceArns);
            this.backupResourceArns(model.backupResourceArns);
            this.backupResourceTags(model.backupResourceTags);
        }

        public final Collection<String> getBackupResourceTypes() {
            if (this.backupResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.backupResourceTypes;
        }

        public final void setBackupResourceTypes(Collection<String> backupResourceTypes) {
            this.backupResourceTypes = ResourceTypeListCopier.copy(backupResourceTypes);
        }

        @Override
        public final Builder backupResourceTypesWithStrings(Collection<String> backupResourceTypes) {
            this.backupResourceTypes = ResourceTypeListCopier.copy(backupResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupResourceTypesWithStrings(String ... backupResourceTypes) {
            this.backupResourceTypesWithStrings(Arrays.asList(backupResourceTypes));
            return this;
        }

        @Override
        public final Builder backupResourceTypes(Collection<ResourceType> backupResourceTypes) {
            this.backupResourceTypes = ResourceTypeListCopier.copyEnumToString(backupResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupResourceTypes(ResourceType ... backupResourceTypes) {
            this.backupResourceTypes(Arrays.asList(backupResourceTypes));
            return this;
        }

        public final BackupCreationTimeFilter.Builder getBackupResourceCreationTime() {
            return this.backupResourceCreationTime != null ? this.backupResourceCreationTime.toBuilder() : null;
        }

        public final void setBackupResourceCreationTime(BackupCreationTimeFilter.BuilderImpl backupResourceCreationTime) {
            this.backupResourceCreationTime = backupResourceCreationTime != null ? backupResourceCreationTime.build() : null;
        }

        @Override
        public final Builder backupResourceCreationTime(BackupCreationTimeFilter backupResourceCreationTime) {
            this.backupResourceCreationTime = backupResourceCreationTime;
            return this;
        }

        public final Collection<String> getSourceResourceArns() {
            if (this.sourceResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceResourceArns;
        }

        public final void setSourceResourceArns(Collection<String> sourceResourceArns) {
            this.sourceResourceArns = ResourceArnListCopier.copy(sourceResourceArns);
        }

        @Override
        public final Builder sourceResourceArns(Collection<String> sourceResourceArns) {
            this.sourceResourceArns = ResourceArnListCopier.copy(sourceResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceResourceArns(String ... sourceResourceArns) {
            this.sourceResourceArns(Arrays.asList(sourceResourceArns));
            return this;
        }

        public final Collection<String> getBackupResourceArns() {
            if (this.backupResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.backupResourceArns;
        }

        public final void setBackupResourceArns(Collection<String> backupResourceArns) {
            this.backupResourceArns = RecoveryPointArnListCopier.copy(backupResourceArns);
        }

        @Override
        public final Builder backupResourceArns(Collection<String> backupResourceArns) {
            this.backupResourceArns = RecoveryPointArnListCopier.copy(backupResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupResourceArns(String ... backupResourceArns) {
            this.backupResourceArns(Arrays.asList(backupResourceArns));
            return this;
        }

        public final Map<String, String> getBackupResourceTags() {
            if (this.backupResourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.backupResourceTags;
        }

        public final void setBackupResourceTags(Map<String, String> backupResourceTags) {
            this.backupResourceTags = TagMapCopier.copy(backupResourceTags);
        }

        @Override
        public final Builder backupResourceTags(Map<String, String> backupResourceTags) {
            this.backupResourceTags = TagMapCopier.copy(backupResourceTags);
            return this;
        }

        public SearchScope build() {
            return new SearchScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchScope> {
        public Builder backupResourceTypesWithStrings(Collection<String> var1);

        public Builder backupResourceTypesWithStrings(String ... var1);

        public Builder backupResourceTypes(Collection<ResourceType> var1);

        public Builder backupResourceTypes(ResourceType ... var1);

        public Builder backupResourceCreationTime(BackupCreationTimeFilter var1);

        default public Builder backupResourceCreationTime(Consumer<BackupCreationTimeFilter.Builder> backupResourceCreationTime) {
            return this.backupResourceCreationTime((BackupCreationTimeFilter)((BackupCreationTimeFilter.Builder)BackupCreationTimeFilter.builder().applyMutation(backupResourceCreationTime)).build());
        }

        public Builder sourceResourceArns(Collection<String> var1);

        public Builder sourceResourceArns(String ... var1);

        public Builder backupResourceArns(Collection<String> var1);

        public Builder backupResourceArns(String ... var1);

        public Builder backupResourceTags(Map<String, String> var1);
    }
}

