/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchRequest;
import software.amazon.awssdk.services.backupsearch.model.ExportSpecification;
import software.amazon.awssdk.services.backupsearch.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSearchResultExportJobRequest
extends BackupSearchRequest
implements ToCopyableBuilder<Builder, StartSearchResultExportJobRequest> {
    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobIdentifier").getter(StartSearchResultExportJobRequest.getter(StartSearchResultExportJobRequest::searchJobIdentifier)).setter(StartSearchResultExportJobRequest.setter(Builder::searchJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build()}).build();
    private static final SdkField<ExportSpecification> EXPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportSpecification").getter(StartSearchResultExportJobRequest.getter(StartSearchResultExportJobRequest::exportSpecification)).setter(StartSearchResultExportJobRequest.setter(Builder::exportSpecification)).constructor(ExportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSpecification").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartSearchResultExportJobRequest.getter(StartSearchResultExportJobRequest::clientToken)).setter(StartSearchResultExportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartSearchResultExportJobRequest.getter(StartSearchResultExportJobRequest::tags)).setter(StartSearchResultExportJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(StartSearchResultExportJobRequest.getter(StartSearchResultExportJobRequest::roleArn)).setter(StartSearchResultExportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOB_IDENTIFIER_FIELD, EXPORT_SPECIFICATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSearchResultExportJobRequest.memberNameToFieldInitializer();
    private final String searchJobIdentifier;
    private final ExportSpecification exportSpecification;
    private final String clientToken;
    private final Map<String, String> tags;
    private final String roleArn;

    private StartSearchResultExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.searchJobIdentifier = builder.searchJobIdentifier;
        this.exportSpecification = builder.exportSpecification;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.roleArn = builder.roleArn;
    }

    public final String searchJobIdentifier() {
        return this.searchJobIdentifier;
    }

    public final ExportSpecification exportSpecification() {
        return this.exportSpecification;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchResultExportJobRequest)) {
            return false;
        }
        StartSearchResultExportJobRequest other = (StartSearchResultExportJobRequest)((Object)obj);
        return Objects.equals(this.searchJobIdentifier(), other.searchJobIdentifier()) && Objects.equals(this.exportSpecification(), other.exportSpecification()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"StartSearchResultExportJobRequest").add("SearchJobIdentifier", (Object)this.searchJobIdentifier()).add("ExportSpecification", (Object)this.exportSpecification()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.searchJobIdentifier()));
            }
            case "ExportSpecification": {
                return Optional.ofNullable(clazz.cast(this.exportSpecification()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        map.put("ExportSpecification", EXPORT_SPECIFICATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchResultExportJobRequest, T> g) {
        return obj -> g.apply((StartSearchResultExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchRequest.BuilderImpl
    implements Builder {
        private String searchJobIdentifier;
        private ExportSpecification exportSpecification;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchResultExportJobRequest model) {
            super(model);
            this.searchJobIdentifier(model.searchJobIdentifier);
            this.exportSpecification(model.exportSpecification);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.roleArn(model.roleArn);
        }

        public final String getSearchJobIdentifier() {
            return this.searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        public final ExportSpecification.Builder getExportSpecification() {
            return this.exportSpecification != null ? this.exportSpecification.toBuilder() : null;
        }

        public final void setExportSpecification(ExportSpecification.BuilderImpl exportSpecification) {
            this.exportSpecification = exportSpecification != null ? exportSpecification.build() : null;
        }

        @Override
        public final Builder exportSpecification(ExportSpecification exportSpecification) {
            this.exportSpecification = exportSpecification;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSearchResultExportJobRequest build() {
            return new StartSearchResultExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSearchResultExportJobRequest> {
        public Builder searchJobIdentifier(String var1);

        public Builder exportSpecification(ExportSpecification var1);

        default public Builder exportSpecification(Consumer<ExportSpecification.Builder> exportSpecification) {
            return this.exportSpecification((ExportSpecification)((ExportSpecification.Builder)ExportSpecification.builder().applyMutation(exportSpecification)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

