/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ExportSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ExportSpecification> {
    private static final SdkField<String> DESTINATION_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationBucket").getter(S3ExportSpecification.getter(S3ExportSpecification::destinationBucket)).setter(S3ExportSpecification.setter(Builder::destinationBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBucket").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefix").getter(S3ExportSpecification.getter(S3ExportSpecification::destinationPrefix)).setter(S3ExportSpecification.setter(Builder::destinationPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_BUCKET_FIELD, DESTINATION_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ExportSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationBucket;
    private final String destinationPrefix;

    private S3ExportSpecification(BuilderImpl builder) {
        this.destinationBucket = builder.destinationBucket;
        this.destinationPrefix = builder.destinationPrefix;
    }

    public final String destinationBucket() {
        return this.destinationBucket;
    }

    public final String destinationPrefix() {
        return this.destinationPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportSpecification)) {
            return false;
        }
        S3ExportSpecification other = (S3ExportSpecification)obj;
        return Objects.equals(this.destinationBucket(), other.destinationBucket()) && Objects.equals(this.destinationPrefix(), other.destinationPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"S3ExportSpecification").add("DestinationBucket", (Object)this.destinationBucket()).add("DestinationPrefix", (Object)this.destinationPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationBucket": {
                return Optional.ofNullable(clazz.cast(this.destinationBucket()));
            }
            case "DestinationPrefix": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DestinationBucket", DESTINATION_BUCKET_FIELD);
        map.put("DestinationPrefix", DESTINATION_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ExportSpecification, T> g) {
        return obj -> g.apply((S3ExportSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationBucket;
        private String destinationPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExportSpecification model) {
            this.destinationBucket(model.destinationBucket);
            this.destinationPrefix(model.destinationPrefix);
        }

        public final String getDestinationBucket() {
            return this.destinationBucket;
        }

        public final void setDestinationBucket(String destinationBucket) {
            this.destinationBucket = destinationBucket;
        }

        @Override
        public final Builder destinationBucket(String destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        public final String getDestinationPrefix() {
            return this.destinationPrefix;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public S3ExportSpecification build() {
            return new S3ExportSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ExportSpecification> {
        public Builder destinationBucket(String var1);

        public Builder destinationPrefix(String var1);
    }
}

