/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ResultItem> {
    private static final SdkField<String> BACKUP_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupResourceArn").getter(S3ResultItem.getter(S3ResultItem::backupResourceArn)).setter(S3ResultItem.setter(Builder::backupResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArn").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(S3ResultItem.getter(S3ResultItem::sourceResourceArn)).setter(S3ResultItem.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(S3ResultItem.getter(S3ResultItem::backupVaultName)).setter(S3ResultItem.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectKey").getter(S3ResultItem.getter(S3ResultItem::objectKey)).setter(S3ResultItem.setter(Builder::objectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").build()}).build();
    private static final SdkField<Long> OBJECT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ObjectSize").getter(S3ResultItem.getter(S3ResultItem::objectSize)).setter(S3ResultItem.setter(Builder::objectSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectSize").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(S3ResultItem.getter(S3ResultItem::creationTime)).setter(S3ResultItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(S3ResultItem.getter(S3ResultItem::eTag)).setter(S3ResultItem.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(S3ResultItem.getter(S3ResultItem::versionId)).setter(S3ResultItem.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RESOURCE_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, OBJECT_KEY_FIELD, OBJECT_SIZE_FIELD, CREATION_TIME_FIELD, E_TAG_FIELD, VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backupResourceArn;
    private final String sourceResourceArn;
    private final String backupVaultName;
    private final String objectKey;
    private final Long objectSize;
    private final Instant creationTime;
    private final String eTag;
    private final String versionId;

    private S3ResultItem(BuilderImpl builder) {
        this.backupResourceArn = builder.backupResourceArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.backupVaultName = builder.backupVaultName;
        this.objectKey = builder.objectKey;
        this.objectSize = builder.objectSize;
        this.creationTime = builder.creationTime;
        this.eTag = builder.eTag;
        this.versionId = builder.versionId;
    }

    public final String backupResourceArn() {
        return this.backupResourceArn;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String objectKey() {
        return this.objectKey;
    }

    public final Long objectSize() {
        return this.objectSize;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResultItem)) {
            return false;
        }
        S3ResultItem other = (S3ResultItem)obj;
        return Objects.equals(this.backupResourceArn(), other.backupResourceArn()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.objectKey(), other.objectKey()) && Objects.equals(this.objectSize(), other.objectSize()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"S3ResultItem").add("BackupResourceArn", (Object)this.backupResourceArn()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("ObjectKey", (Object)(this.objectKey() == null ? null : "*** Sensitive Data Redacted ***")).add("ObjectSize", (Object)this.objectSize()).add("CreationTime", (Object)this.creationTime()).add("ETag", (Object)this.eTag()).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupResourceArn": {
                return Optional.ofNullable(clazz.cast(this.backupResourceArn()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.objectKey()));
            }
            case "ObjectSize": {
                return Optional.ofNullable(clazz.cast(this.objectSize()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupResourceArn", BACKUP_RESOURCE_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("ObjectKey", OBJECT_KEY_FIELD);
        map.put("ObjectSize", OBJECT_SIZE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ResultItem, T> g) {
        return obj -> g.apply((S3ResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupResourceArn;
        private String sourceResourceArn;
        private String backupVaultName;
        private String objectKey;
        private Long objectSize;
        private Instant creationTime;
        private String eTag;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ResultItem model) {
            this.backupResourceArn(model.backupResourceArn);
            this.sourceResourceArn(model.sourceResourceArn);
            this.backupVaultName(model.backupVaultName);
            this.objectKey(model.objectKey);
            this.objectSize(model.objectSize);
            this.creationTime(model.creationTime);
            this.eTag(model.eTag);
            this.versionId(model.versionId);
        }

        public final String getBackupResourceArn() {
            return this.backupResourceArn;
        }

        public final void setBackupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
        }

        @Override
        public final Builder backupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getObjectKey() {
            return this.objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final Long getObjectSize() {
            return this.objectSize;
        }

        public final void setObjectSize(Long objectSize) {
            this.objectSize = objectSize;
        }

        @Override
        public final Builder objectSize(Long objectSize) {
            this.objectSize = objectSize;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public S3ResultItem build() {
            return new S3ResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ResultItem> {
        public Builder backupResourceArn(String var1);

        public Builder sourceResourceArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder objectKey(String var1);

        public Builder objectSize(Long var1);

        public Builder creationTime(Instant var1);

        public Builder eTag(String var1);

        public Builder versionId(String var1);
    }
}

