/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.ResourceType;
import software.amazon.awssdk.services.backupsearch.model.SearchJobState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchJobBackupsResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchJobBackupsResult> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::statusAsString)).setter(SearchJobBackupsResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::statusMessage)).setter(SearchJobBackupsResult.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::resourceTypeAsString)).setter(SearchJobBackupsResult.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> BACKUP_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupResourceArn").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::backupResourceArn)).setter(SearchJobBackupsResult.setter(Builder::backupResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArn").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::sourceResourceArn)).setter(SearchJobBackupsResult.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()}).build();
    private static final SdkField<Instant> INDEX_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IndexCreationTime").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::indexCreationTime)).setter(SearchJobBackupsResult.setter(Builder::indexCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCreationTime").build()}).build();
    private static final SdkField<Instant> BACKUP_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BackupCreationTime").getter(SearchJobBackupsResult.getter(SearchJobBackupsResult::backupCreationTime)).setter(SearchJobBackupsResult.setter(Builder::backupCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_MESSAGE_FIELD, RESOURCE_TYPE_FIELD, BACKUP_RESOURCE_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD, INDEX_CREATION_TIME_FIELD, BACKUP_CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchJobBackupsResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String statusMessage;
    private final String resourceType;
    private final String backupResourceArn;
    private final String sourceResourceArn;
    private final Instant indexCreationTime;
    private final Instant backupCreationTime;

    private SearchJobBackupsResult(BuilderImpl builder) {
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.resourceType = builder.resourceType;
        this.backupResourceArn = builder.backupResourceArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.indexCreationTime = builder.indexCreationTime;
        this.backupCreationTime = builder.backupCreationTime;
    }

    public final SearchJobState status() {
        return SearchJobState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String backupResourceArn() {
        return this.backupResourceArn;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final Instant indexCreationTime() {
        return this.indexCreationTime;
    }

    public final Instant backupCreationTime() {
        return this.backupCreationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupCreationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobBackupsResult)) {
            return false;
        }
        SearchJobBackupsResult other = (SearchJobBackupsResult)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.backupResourceArn(), other.backupResourceArn()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.indexCreationTime(), other.indexCreationTime()) && Objects.equals(this.backupCreationTime(), other.backupCreationTime());
    }

    public final String toString() {
        return ToString.builder((String)"SearchJobBackupsResult").add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ResourceType", (Object)this.resourceTypeAsString()).add("BackupResourceArn", (Object)this.backupResourceArn()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("IndexCreationTime", (Object)this.indexCreationTime()).add("BackupCreationTime", (Object)this.backupCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "BackupResourceArn": {
                return Optional.ofNullable(clazz.cast(this.backupResourceArn()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "IndexCreationTime": {
                return Optional.ofNullable(clazz.cast(this.indexCreationTime()));
            }
            case "BackupCreationTime": {
                return Optional.ofNullable(clazz.cast(this.backupCreationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("BackupResourceArn", BACKUP_RESOURCE_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("IndexCreationTime", INDEX_CREATION_TIME_FIELD);
        map.put("BackupCreationTime", BACKUP_CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchJobBackupsResult, T> g) {
        return obj -> g.apply((SearchJobBackupsResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String statusMessage;
        private String resourceType;
        private String backupResourceArn;
        private String sourceResourceArn;
        private Instant indexCreationTime;
        private Instant backupCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobBackupsResult model) {
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.resourceType(model.resourceType);
            this.backupResourceArn(model.backupResourceArn);
            this.sourceResourceArn(model.sourceResourceArn);
            this.indexCreationTime(model.indexCreationTime);
            this.backupCreationTime(model.backupCreationTime);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SearchJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getBackupResourceArn() {
            return this.backupResourceArn;
        }

        public final void setBackupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
        }

        @Override
        public final Builder backupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final Instant getIndexCreationTime() {
            return this.indexCreationTime;
        }

        public final void setIndexCreationTime(Instant indexCreationTime) {
            this.indexCreationTime = indexCreationTime;
        }

        @Override
        public final Builder indexCreationTime(Instant indexCreationTime) {
            this.indexCreationTime = indexCreationTime;
            return this;
        }

        public final Instant getBackupCreationTime() {
            return this.backupCreationTime;
        }

        public final void setBackupCreationTime(Instant backupCreationTime) {
            this.backupCreationTime = backupCreationTime;
        }

        @Override
        public final Builder backupCreationTime(Instant backupCreationTime) {
            this.backupCreationTime = backupCreationTime;
            return this;
        }

        public SearchJobBackupsResult build() {
            return new SearchJobBackupsResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchJobBackupsResult> {
        public Builder status(String var1);

        public Builder status(SearchJobState var1);

        public Builder statusMessage(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder backupResourceArn(String var1);

        public Builder sourceResourceArn(String var1);

        public Builder indexCreationTime(Instant var1);

        public Builder backupCreationTime(Instant var1);
    }
}

