/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchAsyncClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse;
import software.amazon.awssdk.services.backupsearch.model.SearchJobBackupsResult;

public class ListSearchJobBackupsPublisher
implements SdkPublisher<ListSearchJobBackupsResponse> {
    private final BackupSearchAsyncClient client;
    private final ListSearchJobBackupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSearchJobBackupsPublisher(BackupSearchAsyncClient client, ListSearchJobBackupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSearchJobBackupsPublisher(BackupSearchAsyncClient client, ListSearchJobBackupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSearchJobBackupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSearchJobBackupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchJobBackupsResult> results() {
        Function<ListSearchJobBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSearchJobBackupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSearchJobBackupsResponseFetcher
    implements AsyncPageFetcher<ListSearchJobBackupsResponse> {
        private ListSearchJobBackupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchJobBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSearchJobBackupsResponse> nextPage(ListSearchJobBackupsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchJobBackupsPublisher.this.client.listSearchJobBackups(ListSearchJobBackupsPublisher.this.firstRequest);
            }
            return ListSearchJobBackupsPublisher.this.client.listSearchJobBackups((ListSearchJobBackupsRequest)((Object)ListSearchJobBackupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

