/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bcmdataexports.BcmDataExportsAsyncClientBuilder;
import software.amazon.awssdk.services.bcmdataexports.BcmDataExportsServiceClientConfiguration;
import software.amazon.awssdk.services.bcmdataexports.DefaultBcmDataExportsAsyncClientBuilder;
import software.amazon.awssdk.services.bcmdataexports.model.CreateExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.CreateExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.DeleteExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.DeleteExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.GetExecutionRequest;
import software.amazon.awssdk.services.bcmdataexports.model.GetExecutionResponse;
import software.amazon.awssdk.services.bcmdataexports.model.GetExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.GetExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.GetTableRequest;
import software.amazon.awssdk.services.bcmdataexports.model.GetTableResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListExecutionsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListExecutionsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListExportsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListExportsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListTablesRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListTablesResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmdataexports.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmdataexports.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmdataexports.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmdataexports.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmdataexports.model.UpdateExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.UpdateExportResponse;
import software.amazon.awssdk.services.bcmdataexports.paginators.ListExecutionsPublisher;
import software.amazon.awssdk.services.bcmdataexports.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.bcmdataexports.paginators.ListTablesPublisher;

@SdkPublicApi
@ThreadSafe
public interface BcmDataExportsAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "bcm-data-exports";
    public static final String SERVICE_METADATA_ID = "bcm-data-exports";

    default public CompletableFuture<CreateExportResponse> createExport(CreateExportRequest createExportRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateExportResponse> createExport(Consumer<CreateExportRequest.Builder> createExportRequest) {
        return this.createExport((CreateExportRequest)((Object)((CreateExportRequest.Builder)CreateExportRequest.builder().applyMutation(createExportRequest)).build()));
    }

    default public CompletableFuture<DeleteExportResponse> deleteExport(DeleteExportRequest deleteExportRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteExportResponse> deleteExport(Consumer<DeleteExportRequest.Builder> deleteExportRequest) {
        return this.deleteExport((DeleteExportRequest)((Object)((DeleteExportRequest.Builder)DeleteExportRequest.builder().applyMutation(deleteExportRequest)).build()));
    }

    default public CompletableFuture<GetExecutionResponse> getExecution(GetExecutionRequest getExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetExecutionResponse> getExecution(Consumer<GetExecutionRequest.Builder> getExecutionRequest) {
        return this.getExecution((GetExecutionRequest)((Object)((GetExecutionRequest.Builder)GetExecutionRequest.builder().applyMutation(getExecutionRequest)).build()));
    }

    default public CompletableFuture<GetExportResponse> getExport(GetExportRequest getExportRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetExportResponse> getExport(Consumer<GetExportRequest.Builder> getExportRequest) {
        return this.getExport((GetExportRequest)((Object)((GetExportRequest.Builder)GetExportRequest.builder().applyMutation(getExportRequest)).build()));
    }

    default public CompletableFuture<GetTableResponse> getTable(GetTableRequest getTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetTableResponse> getTable(Consumer<GetTableRequest.Builder> getTableRequest) {
        return this.getTable((GetTableRequest)((Object)((GetTableRequest.Builder)GetTableRequest.builder().applyMutation(getTableRequest)).build()));
    }

    default public CompletableFuture<ListExecutionsResponse> listExecutions(ListExecutionsRequest listExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListExecutionsResponse> listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return this.listExecutions((ListExecutionsRequest)((Object)((ListExecutionsRequest.Builder)ListExecutionsRequest.builder().applyMutation(listExecutionsRequest)).build()));
    }

    default public ListExecutionsPublisher listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) {
        return new ListExecutionsPublisher(this, listExecutionsRequest);
    }

    default public ListExecutionsPublisher listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return this.listExecutionsPaginator((ListExecutionsRequest)((Object)((ListExecutionsRequest.Builder)ListExecutionsRequest.builder().applyMutation(listExecutionsRequest)).build()));
    }

    default public CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return this.listExports((ListExportsRequest)((Object)((ListExportsRequest.Builder)ListExportsRequest.builder().applyMutation(listExportsRequest)).build()));
    }

    default public ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, listExportsRequest);
    }

    default public ListExportsPublisher listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return this.listExportsPaginator((ListExportsRequest)((Object)((ListExportsRequest.Builder)ListExportsRequest.builder().applyMutation(listExportsRequest)).build()));
    }

    default public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTablesResponse> listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return this.listTables((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        return new ListTablesPublisher(this, listTablesRequest);
    }

    default public ListTablesPublisher listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return this.listTablesPaginator((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateExportResponse> updateExport(UpdateExportRequest updateExportRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateExportResponse> updateExport(Consumer<UpdateExportRequest.Builder> updateExportRequest) {
        return this.updateExport((UpdateExportRequest)((Object)((UpdateExportRequest.Builder)UpdateExportRequest.builder().applyMutation(updateExportRequest)).build()));
    }

    default public BcmDataExportsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static BcmDataExportsAsyncClient create() {
        return (BcmDataExportsAsyncClient)BcmDataExportsAsyncClient.builder().build();
    }

    public static BcmDataExportsAsyncClientBuilder builder() {
        return new DefaultBcmDataExportsAsyncClientBuilder();
    }
}

