/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmdataexports.model.TableConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQuery> {
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatement").getter(DataQuery.getter(DataQuery::queryStatement)).setter(DataQuery.setter(Builder::queryStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> TABLE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TableConfigurations").getter(DataQuery.getter(DataQuery::tableConfigurations)).setter(DataQuery.setter(Builder::tableConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATEMENT_FIELD, TABLE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryStatement;
    private final Map<String, Map<String, String>> tableConfigurations;

    private DataQuery(BuilderImpl builder) {
        this.queryStatement = builder.queryStatement;
        this.tableConfigurations = builder.tableConfigurations;
    }

    public final String queryStatement() {
        return this.queryStatement;
    }

    public final boolean hasTableConfigurations() {
        return this.tableConfigurations != null && !(this.tableConfigurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> tableConfigurations() {
        return this.tableConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableConfigurations() ? this.tableConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQuery)) {
            return false;
        }
        DataQuery other = (DataQuery)obj;
        return Objects.equals(this.queryStatement(), other.queryStatement()) && this.hasTableConfigurations() == other.hasTableConfigurations() && Objects.equals(this.tableConfigurations(), other.tableConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"DataQuery").add("QueryStatement", (Object)this.queryStatement()).add("TableConfigurations", this.hasTableConfigurations() ? this.tableConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryStatement": {
                return Optional.ofNullable(clazz.cast(this.queryStatement()));
            }
            case "TableConfigurations": {
                return Optional.ofNullable(clazz.cast(this.tableConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryStatement", QUERY_STATEMENT_FIELD);
        map.put("TableConfigurations", TABLE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQuery, T> g) {
        return obj -> g.apply((DataQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryStatement;
        private Map<String, Map<String, String>> tableConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataQuery model) {
            this.queryStatement(model.queryStatement);
            this.tableConfigurations(model.tableConfigurations);
        }

        public final String getQueryStatement() {
            return this.queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getTableConfigurations() {
            if (this.tableConfigurations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tableConfigurations;
        }

        public final void setTableConfigurations(Map<String, ? extends Map<String, String>> tableConfigurations) {
            this.tableConfigurations = TableConfigurationsCopier.copy(tableConfigurations);
        }

        @Override
        public final Builder tableConfigurations(Map<String, ? extends Map<String, String>> tableConfigurations) {
            this.tableConfigurations = TableConfigurationsCopier.copy(tableConfigurations);
            return this;
        }

        public DataQuery build() {
            return new DataQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQuery> {
        public Builder queryStatement(String var1);

        public Builder tableConfigurations(Map<String, ? extends Map<String, String>> var1);
    }
}

