/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the word policy configured for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailWordPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailWordPolicy.Builder, GuardrailWordPolicy> {
    private static final SdkField<List<GuardrailWord>> WORDS_FIELD = SdkField
            .<List<GuardrailWord>> builder(MarshallingType.LIST)
            .memberName("words")
            .getter(getter(GuardrailWordPolicy::words))
            .setter(setter(Builder::words))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("words").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailWord> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailWord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailManagedWords>> MANAGED_WORD_LISTS_FIELD = SdkField
            .<List<GuardrailManagedWords>> builder(MarshallingType.LIST)
            .memberName("managedWordLists")
            .getter(getter(GuardrailWordPolicy::managedWordLists))
            .setter(setter(Builder::managedWordLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWordLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailManagedWords> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailManagedWords::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORDS_FIELD,
            MANAGED_WORD_LISTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GuardrailWord> words;

    private final List<GuardrailManagedWords> managedWordLists;

    private GuardrailWordPolicy(BuilderImpl builder) {
        this.words = builder.words;
        this.managedWordLists = builder.managedWordLists;
    }

    /**
     * For responses, this returns true if the service returned a value for the Words property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasWords() {
        return words != null && !(words instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of words configured for the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWords} method.
     * </p>
     * 
     * @return A list of words configured for the guardrail.
     */
    public final List<GuardrailWord> words() {
        return words;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedWordLists property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedWordLists() {
        return managedWordLists != null && !(managedWordLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed words configured for the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedWordLists} method.
     * </p>
     * 
     * @return A list of managed words configured for the guardrail.
     */
    public final List<GuardrailManagedWords> managedWordLists() {
        return managedWordLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWords() ? words() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedWordLists() ? managedWordLists() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailWordPolicy)) {
            return false;
        }
        GuardrailWordPolicy other = (GuardrailWordPolicy) obj;
        return hasWords() == other.hasWords() && Objects.equals(words(), other.words())
                && hasManagedWordLists() == other.hasManagedWordLists()
                && Objects.equals(managedWordLists(), other.managedWordLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailWordPolicy").add("Words", hasWords() ? words() : null)
                .add("ManagedWordLists", hasManagedWordLists() ? managedWordLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "words":
            return Optional.ofNullable(clazz.cast(words()));
        case "managedWordLists":
            return Optional.ofNullable(clazz.cast(managedWordLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailWordPolicy, T> g) {
        return obj -> g.apply((GuardrailWordPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailWordPolicy> {
        /**
         * <p>
         * A list of words configured for the guardrail.
         * </p>
         * 
         * @param words
         *        A list of words configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(Collection<GuardrailWord> words);

        /**
         * <p>
         * A list of words configured for the guardrail.
         * </p>
         * 
         * @param words
         *        A list of words configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(GuardrailWord... words);

        /**
         * <p>
         * A list of words configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailWord.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailWord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailWord.Builder#build()} is called immediately and
         * its result is passed to {@link #words(List<GuardrailWord>)}.
         * 
         * @param words
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailWord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #words(java.util.Collection<GuardrailWord>)
         */
        Builder words(Consumer<GuardrailWord.Builder>... words);

        /**
         * <p>
         * A list of managed words configured for the guardrail.
         * </p>
         * 
         * @param managedWordLists
         *        A list of managed words configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWordLists(Collection<GuardrailManagedWords> managedWordLists);

        /**
         * <p>
         * A list of managed words configured for the guardrail.
         * </p>
         * 
         * @param managedWordLists
         *        A list of managed words configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWordLists(GuardrailManagedWords... managedWordLists);

        /**
         * <p>
         * A list of managed words configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWords.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWords#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWords.Builder#build()} is called
         * immediately and its result is passed to {@link #managedWordLists(List<GuardrailManagedWords>)}.
         * 
         * @param managedWordLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWords.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedWordLists(java.util.Collection<GuardrailManagedWords>)
         */
        Builder managedWordLists(Consumer<GuardrailManagedWords.Builder>... managedWordLists);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailWord> words = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailManagedWords> managedWordLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailWordPolicy model) {
            words(model.words);
            managedWordLists(model.managedWordLists);
        }

        public final List<GuardrailWord.Builder> getWords() {
            List<GuardrailWord.Builder> result = GuardrailWordsCopier.copyToBuilder(this.words);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWords(Collection<GuardrailWord.BuilderImpl> words) {
            this.words = GuardrailWordsCopier.copyFromBuilder(words);
        }

        @Override
        public final Builder words(Collection<GuardrailWord> words) {
            this.words = GuardrailWordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(GuardrailWord... words) {
            words(Arrays.asList(words));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(Consumer<GuardrailWord.Builder>... words) {
            words(Stream.of(words).map(c -> GuardrailWord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailManagedWords.Builder> getManagedWordLists() {
            List<GuardrailManagedWords.Builder> result = GuardrailManagedWordListsCopier.copyToBuilder(this.managedWordLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedWordLists(Collection<GuardrailManagedWords.BuilderImpl> managedWordLists) {
            this.managedWordLists = GuardrailManagedWordListsCopier.copyFromBuilder(managedWordLists);
        }

        @Override
        public final Builder managedWordLists(Collection<GuardrailManagedWords> managedWordLists) {
            this.managedWordLists = GuardrailManagedWordListsCopier.copy(managedWordLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordLists(GuardrailManagedWords... managedWordLists) {
            managedWordLists(Arrays.asList(managedWordLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordLists(Consumer<GuardrailManagedWords.Builder>... managedWordLists) {
            managedWordLists(Stream.of(managedWordLists).map(c -> GuardrailManagedWords.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailWordPolicy build() {
            return new GuardrailWordPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
