/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelInvocationJobsResponse extends BedrockResponse implements
        ToCopyableBuilder<ListModelInvocationJobsResponse.Builder, ListModelInvocationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListModelInvocationJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ModelInvocationJobSummary>> INVOCATION_JOB_SUMMARIES_FIELD = SdkField
            .<List<ModelInvocationJobSummary>> builder(MarshallingType.LIST)
            .memberName("invocationJobSummaries")
            .getter(getter(ListModelInvocationJobsResponse::invocationJobSummaries))
            .setter(setter(Builder::invocationJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelInvocationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelInvocationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INVOCATION_JOB_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<ModelInvocationJobSummary> invocationJobSummaries;

    private ListModelInvocationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.invocationJobSummaries = builder.invocationJobSummaries;
    }

    /**
     * <p>
     * If there are more results than can fit in the response, a <code>nextToken</code> is returned. Use the
     * <code>nextToken</code> in a request to return the next batch of results.
     * </p>
     * 
     * @return If there are more results than can fit in the response, a <code>nextToken</code> is returned. Use the
     *         <code>nextToken</code> in a request to return the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvocationJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInvocationJobSummaries() {
        return invocationJobSummaries != null && !(invocationJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of items, each of which contains a summary about a batch inference job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvocationJobSummaries} method.
     * </p>
     * 
     * @return A list of items, each of which contains a summary about a batch inference job.
     */
    public final List<ModelInvocationJobSummary> invocationJobSummaries() {
        return invocationJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInvocationJobSummaries() ? invocationJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelInvocationJobsResponse)) {
            return false;
        }
        ListModelInvocationJobsResponse other = (ListModelInvocationJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasInvocationJobSummaries() == other.hasInvocationJobSummaries()
                && Objects.equals(invocationJobSummaries(), other.invocationJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelInvocationJobsResponse").add("NextToken", nextToken())
                .add("InvocationJobSummaries", hasInvocationJobSummaries() ? invocationJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "invocationJobSummaries":
            return Optional.ofNullable(clazz.cast(invocationJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelInvocationJobsResponse, T> g) {
        return obj -> g.apply((ListModelInvocationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelInvocationJobsResponse> {
        /**
         * <p>
         * If there are more results than can fit in the response, a <code>nextToken</code> is returned. Use the
         * <code>nextToken</code> in a request to return the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        If there are more results than can fit in the response, a <code>nextToken</code> is returned. Use the
         *        <code>nextToken</code> in a request to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of items, each of which contains a summary about a batch inference job.
         * </p>
         * 
         * @param invocationJobSummaries
         *        A list of items, each of which contains a summary about a batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationJobSummaries(Collection<ModelInvocationJobSummary> invocationJobSummaries);

        /**
         * <p>
         * A list of items, each of which contains a summary about a batch inference job.
         * </p>
         * 
         * @param invocationJobSummaries
         *        A list of items, each of which contains a summary about a batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationJobSummaries(ModelInvocationJobSummary... invocationJobSummaries);

        /**
         * <p>
         * A list of items, each of which contains a summary about a batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #invocationJobSummaries(List<ModelInvocationJobSummary>)}.
         * 
         * @param invocationJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationJobSummaries(java.util.Collection<ModelInvocationJobSummary>)
         */
        Builder invocationJobSummaries(Consumer<ModelInvocationJobSummary.Builder>... invocationJobSummaries);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ModelInvocationJobSummary> invocationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelInvocationJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            invocationJobSummaries(model.invocationJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelInvocationJobSummary.Builder> getInvocationJobSummaries() {
            List<ModelInvocationJobSummary.Builder> result = ModelInvocationJobSummariesCopier
                    .copyToBuilder(this.invocationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationJobSummaries(Collection<ModelInvocationJobSummary.BuilderImpl> invocationJobSummaries) {
            this.invocationJobSummaries = ModelInvocationJobSummariesCopier.copyFromBuilder(invocationJobSummaries);
        }

        @Override
        public final Builder invocationJobSummaries(Collection<ModelInvocationJobSummary> invocationJobSummaries) {
            this.invocationJobSummaries = ModelInvocationJobSummariesCopier.copy(invocationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationJobSummaries(ModelInvocationJobSummary... invocationJobSummaries) {
            invocationJobSummaries(Arrays.asList(invocationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationJobSummaries(Consumer<ModelInvocationJobSummary.Builder>... invocationJobSummaries) {
            invocationJobSummaries(Stream.of(invocationJobSummaries)
                    .map(c -> ModelInvocationJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelInvocationJobsResponse build() {
            return new ListModelInvocationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
