/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration of the S3 location of the output data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInvocationJobS3OutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInvocationJobS3OutputDataConfig.Builder, ModelInvocationJobS3OutputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(ModelInvocationJobS3OutputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> S3_ENCRYPTION_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3EncryptionKeyId").getter(getter(ModelInvocationJobS3OutputDataConfig::s3EncryptionKeyId))
            .setter(setter(Builder::s3EncryptionKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3EncryptionKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            S3_ENCRYPTION_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String s3EncryptionKeyId;

    private ModelInvocationJobS3OutputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.s3EncryptionKeyId = builder.s3EncryptionKeyId;
    }

    /**
     * <p>
     * The S3 location of the output data.
     * </p>
     * 
     * @return The S3 location of the output data.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The unique identifier of the key that encrypts the S3 location of the output data.
     * </p>
     * 
     * @return The unique identifier of the key that encrypts the S3 location of the output data.
     */
    public final String s3EncryptionKeyId() {
        return s3EncryptionKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(s3EncryptionKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationJobS3OutputDataConfig)) {
            return false;
        }
        ModelInvocationJobS3OutputDataConfig other = (ModelInvocationJobS3OutputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(s3EncryptionKeyId(), other.s3EncryptionKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInvocationJobS3OutputDataConfig").add("S3Uri", s3Uri())
                .add("S3EncryptionKeyId", s3EncryptionKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "s3EncryptionKeyId":
            return Optional.ofNullable(clazz.cast(s3EncryptionKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationJobS3OutputDataConfig, T> g) {
        return obj -> g.apply((ModelInvocationJobS3OutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInvocationJobS3OutputDataConfig> {
        /**
         * <p>
         * The S3 location of the output data.
         * </p>
         * 
         * @param s3Uri
         *        The S3 location of the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The unique identifier of the key that encrypts the S3 location of the output data.
         * </p>
         * 
         * @param s3EncryptionKeyId
         *        The unique identifier of the key that encrypts the S3 location of the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3EncryptionKeyId(String s3EncryptionKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String s3EncryptionKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationJobS3OutputDataConfig model) {
            s3Uri(model.s3Uri);
            s3EncryptionKeyId(model.s3EncryptionKeyId);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3EncryptionKeyId() {
            return s3EncryptionKeyId;
        }

        public final void setS3EncryptionKeyId(String s3EncryptionKeyId) {
            this.s3EncryptionKeyId = s3EncryptionKeyId;
        }

        @Override
        public final Builder s3EncryptionKeyId(String s3EncryptionKeyId) {
            this.s3EncryptionKeyId = s3EncryptionKeyId;
            return this;
        }

        @Override
        public ModelInvocationJobS3OutputDataConfig build() {
            return new ModelInvocationJobS3OutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
