/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationModelConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationModelConfig> {
    private static final SdkField<EvaluationBedrockModel> BEDROCK_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bedrockModel").getter(EvaluationModelConfig.getter(EvaluationModelConfig::bedrockModel)).setter(EvaluationModelConfig.setter(Builder::bedrockModel)).constructor(EvaluationBedrockModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEDROCK_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationModelConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationBedrockModel bedrockModel;
    private final Type type;

    private EvaluationModelConfig(BuilderImpl builder) {
        this.bedrockModel = builder.bedrockModel;
        this.type = builder.type;
    }

    public final EvaluationBedrockModel bedrockModel() {
        return this.bedrockModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockModel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationModelConfig)) {
            return false;
        }
        EvaluationModelConfig other = (EvaluationModelConfig)obj;
        return Objects.equals(this.bedrockModel(), other.bedrockModel());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationModelConfig").add("BedrockModel", (Object)this.bedrockModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bedrockModel": {
                return Optional.ofNullable(clazz.cast(this.bedrockModel()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationModelConfig fromBedrockModel(EvaluationBedrockModel bedrockModel) {
        return (EvaluationModelConfig)EvaluationModelConfig.builder().bedrockModel(bedrockModel).build();
    }

    public static EvaluationModelConfig fromBedrockModel(Consumer<EvaluationBedrockModel.Builder> bedrockModel) {
        EvaluationBedrockModel.Builder builder = EvaluationBedrockModel.builder();
        bedrockModel.accept(builder);
        return EvaluationModelConfig.fromBedrockModel((EvaluationBedrockModel)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<EvaluationBedrockModel>> map = new HashMap<String, SdkField<EvaluationBedrockModel>>();
        map.put("bedrockModel", BEDROCK_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationModelConfig, T> g) {
        return obj -> g.apply((EvaluationModelConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BEDROCK_MODEL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationBedrockModel bedrockModel;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationModelConfig model) {
            this.bedrockModel(model.bedrockModel);
        }

        public final EvaluationBedrockModel.Builder getBedrockModel() {
            return this.bedrockModel != null ? this.bedrockModel.toBuilder() : null;
        }

        public final void setBedrockModel(EvaluationBedrockModel.BuilderImpl bedrockModel) {
            EvaluationBedrockModel oldValue = this.bedrockModel;
            this.bedrockModel = bedrockModel != null ? bedrockModel.build() : null;
            this.handleUnionValueChange(Type.BEDROCK_MODEL, oldValue, this.bedrockModel);
        }

        @Override
        public final Builder bedrockModel(EvaluationBedrockModel bedrockModel) {
            EvaluationBedrockModel oldValue = this.bedrockModel;
            this.bedrockModel = bedrockModel;
            this.handleUnionValueChange(Type.BEDROCK_MODEL, oldValue, this.bedrockModel);
            return this;
        }

        public EvaluationModelConfig build() {
            return new EvaluationModelConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationModelConfig> {
        public Builder bedrockModel(EvaluationBedrockModel var1);

        default public Builder bedrockModel(Consumer<EvaluationBedrockModel.Builder> bedrockModel) {
            return this.bedrockModel((EvaluationBedrockModel)((EvaluationBedrockModel.Builder)EvaluationBedrockModel.builder().applyMutation(bedrockModel)).build());
        }
    }
}

