/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.EvaluationBedrockKnowledgeBaseIdentifiersCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluationPrecomputedRagSourceIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationRagConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationRagConfigSummary> {
    private static final SdkField<List<String>> BEDROCK_KNOWLEDGE_BASE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bedrockKnowledgeBaseIdentifiers").getter(EvaluationRagConfigSummary.getter(EvaluationRagConfigSummary::bedrockKnowledgeBaseIdentifiers)).setter(EvaluationRagConfigSummary.setter(Builder::bedrockKnowledgeBaseIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeBaseIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRECOMPUTED_RAG_SOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("precomputedRagSourceIdentifiers").getter(EvaluationRagConfigSummary.getter(EvaluationRagConfigSummary::precomputedRagSourceIdentifiers)).setter(EvaluationRagConfigSummary.setter(Builder::precomputedRagSourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precomputedRagSourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEDROCK_KNOWLEDGE_BASE_IDENTIFIERS_FIELD, PRECOMPUTED_RAG_SOURCE_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationRagConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> bedrockKnowledgeBaseIdentifiers;
    private final List<String> precomputedRagSourceIdentifiers;

    private EvaluationRagConfigSummary(BuilderImpl builder) {
        this.bedrockKnowledgeBaseIdentifiers = builder.bedrockKnowledgeBaseIdentifiers;
        this.precomputedRagSourceIdentifiers = builder.precomputedRagSourceIdentifiers;
    }

    public final boolean hasBedrockKnowledgeBaseIdentifiers() {
        return this.bedrockKnowledgeBaseIdentifiers != null && !(this.bedrockKnowledgeBaseIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> bedrockKnowledgeBaseIdentifiers() {
        return this.bedrockKnowledgeBaseIdentifiers;
    }

    public final boolean hasPrecomputedRagSourceIdentifiers() {
        return this.precomputedRagSourceIdentifiers != null && !(this.precomputedRagSourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> precomputedRagSourceIdentifiers() {
        return this.precomputedRagSourceIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBedrockKnowledgeBaseIdentifiers() ? this.bedrockKnowledgeBaseIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrecomputedRagSourceIdentifiers() ? this.precomputedRagSourceIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationRagConfigSummary)) {
            return false;
        }
        EvaluationRagConfigSummary other = (EvaluationRagConfigSummary)obj;
        return this.hasBedrockKnowledgeBaseIdentifiers() == other.hasBedrockKnowledgeBaseIdentifiers() && Objects.equals(this.bedrockKnowledgeBaseIdentifiers(), other.bedrockKnowledgeBaseIdentifiers()) && this.hasPrecomputedRagSourceIdentifiers() == other.hasPrecomputedRagSourceIdentifiers() && Objects.equals(this.precomputedRagSourceIdentifiers(), other.precomputedRagSourceIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationRagConfigSummary").add("BedrockKnowledgeBaseIdentifiers", this.hasBedrockKnowledgeBaseIdentifiers() ? this.bedrockKnowledgeBaseIdentifiers() : null).add("PrecomputedRagSourceIdentifiers", this.hasPrecomputedRagSourceIdentifiers() ? this.precomputedRagSourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bedrockKnowledgeBaseIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.bedrockKnowledgeBaseIdentifiers()));
            }
            case "precomputedRagSourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.precomputedRagSourceIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("bedrockKnowledgeBaseIdentifiers", BEDROCK_KNOWLEDGE_BASE_IDENTIFIERS_FIELD);
        map.put("precomputedRagSourceIdentifiers", PRECOMPUTED_RAG_SOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationRagConfigSummary, T> g) {
        return obj -> g.apply((EvaluationRagConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> bedrockKnowledgeBaseIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> precomputedRagSourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationRagConfigSummary model) {
            this.bedrockKnowledgeBaseIdentifiers(model.bedrockKnowledgeBaseIdentifiers);
            this.precomputedRagSourceIdentifiers(model.precomputedRagSourceIdentifiers);
        }

        public final Collection<String> getBedrockKnowledgeBaseIdentifiers() {
            if (this.bedrockKnowledgeBaseIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bedrockKnowledgeBaseIdentifiers;
        }

        public final void setBedrockKnowledgeBaseIdentifiers(Collection<String> bedrockKnowledgeBaseIdentifiers) {
            this.bedrockKnowledgeBaseIdentifiers = EvaluationBedrockKnowledgeBaseIdentifiersCopier.copy(bedrockKnowledgeBaseIdentifiers);
        }

        @Override
        public final Builder bedrockKnowledgeBaseIdentifiers(Collection<String> bedrockKnowledgeBaseIdentifiers) {
            this.bedrockKnowledgeBaseIdentifiers = EvaluationBedrockKnowledgeBaseIdentifiersCopier.copy(bedrockKnowledgeBaseIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockKnowledgeBaseIdentifiers(String ... bedrockKnowledgeBaseIdentifiers) {
            this.bedrockKnowledgeBaseIdentifiers(Arrays.asList(bedrockKnowledgeBaseIdentifiers));
            return this;
        }

        public final Collection<String> getPrecomputedRagSourceIdentifiers() {
            if (this.precomputedRagSourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.precomputedRagSourceIdentifiers;
        }

        public final void setPrecomputedRagSourceIdentifiers(Collection<String> precomputedRagSourceIdentifiers) {
            this.precomputedRagSourceIdentifiers = EvaluationPrecomputedRagSourceIdentifiersCopier.copy(precomputedRagSourceIdentifiers);
        }

        @Override
        public final Builder precomputedRagSourceIdentifiers(Collection<String> precomputedRagSourceIdentifiers) {
            this.precomputedRagSourceIdentifiers = EvaluationPrecomputedRagSourceIdentifiersCopier.copy(precomputedRagSourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder precomputedRagSourceIdentifiers(String ... precomputedRagSourceIdentifiers) {
            this.precomputedRagSourceIdentifiers(Arrays.asList(precomputedRagSourceIdentifiers));
            return this;
        }

        public EvaluationRagConfigSummary build() {
            return new EvaluationRagConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationRagConfigSummary> {
        public Builder bedrockKnowledgeBaseIdentifiers(Collection<String> var1);

        public Builder bedrockKnowledgeBaseIdentifiers(String ... var1);

        public Builder precomputedRagSourceIdentifiers(Collection<String> var1);

        public Builder precomputedRagSourceIdentifiers(String ... var1);
    }
}

