/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RatingScaleItemValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RatingScaleItemValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(RatingScaleItemValue.getter(RatingScaleItemValue::stringValue)).setter(RatingScaleItemValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<Float> FLOAT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("floatValue").getter(RatingScaleItemValue.getter(RatingScaleItemValue::floatValue)).setter(RatingScaleItemValue.setter(Builder::floatValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("floatValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, FLOAT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RatingScaleItemValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final Float floatValue;
    private final Type type;

    private RatingScaleItemValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.floatValue = builder.floatValue;
        this.type = builder.type;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final Float floatValue() {
        return this.floatValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.floatValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RatingScaleItemValue)) {
            return false;
        }
        RatingScaleItemValue other = (RatingScaleItemValue)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.floatValue(), other.floatValue());
    }

    public final String toString() {
        return ToString.builder((String)"RatingScaleItemValue").add("StringValue", (Object)this.stringValue()).add("FloatValue", (Object)this.floatValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "floatValue": {
                return Optional.ofNullable(clazz.cast(this.floatValue()));
            }
        }
        return Optional.empty();
    }

    public static RatingScaleItemValue fromStringValue(String stringValue) {
        return (RatingScaleItemValue)RatingScaleItemValue.builder().stringValue(stringValue).build();
    }

    public static RatingScaleItemValue fromFloatValue(Float floatValue) {
        return (RatingScaleItemValue)RatingScaleItemValue.builder().floatValue(floatValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("floatValue", FLOAT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RatingScaleItemValue, T> g) {
        return obj -> g.apply((RatingScaleItemValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STRING_VALUE,
        FLOAT_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private Float floatValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RatingScaleItemValue model) {
            this.stringValue(model.stringValue);
            this.floatValue(model.floatValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Float getFloatValue() {
            return this.floatValue;
        }

        public final void setFloatValue(Float floatValue) {
            Float oldValue = this.floatValue;
            this.floatValue = floatValue;
            this.handleUnionValueChange(Type.FLOAT_VALUE, oldValue, this.floatValue);
        }

        @Override
        public final Builder floatValue(Float floatValue) {
            Float oldValue = this.floatValue;
            this.floatValue = floatValue;
            this.handleUnionValueChange(Type.FLOAT_VALUE, oldValue, this.floatValue);
            return this;
        }

        public RatingScaleItemValue build() {
            return new RatingScaleItemValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RatingScaleItemValue> {
        public Builder stringValue(String var1);

        public Builder floatValue(Float var1);
    }
}

