/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.DataProcessingDetails;
import software.amazon.awssdk.services.bedrock.model.TrainingDetails;
import software.amazon.awssdk.services.bedrock.model.ValidationDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatusDetails> {
    private static final SdkField<ValidationDetails> VALIDATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationDetails").getter(StatusDetails.getter(StatusDetails::validationDetails)).setter(StatusDetails.setter(Builder::validationDetails)).constructor(ValidationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDetails").build()}).build();
    private static final SdkField<DataProcessingDetails> DATA_PROCESSING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataProcessingDetails").getter(StatusDetails.getter(StatusDetails::dataProcessingDetails)).setter(StatusDetails.setter(Builder::dataProcessingDetails)).constructor(DataProcessingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProcessingDetails").build()}).build();
    private static final SdkField<TrainingDetails> TRAINING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDetails").getter(StatusDetails.getter(StatusDetails::trainingDetails)).setter(StatusDetails.setter(Builder::trainingDetails)).constructor(TrainingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_DETAILS_FIELD, DATA_PROCESSING_DETAILS_FIELD, TRAINING_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StatusDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ValidationDetails validationDetails;
    private final DataProcessingDetails dataProcessingDetails;
    private final TrainingDetails trainingDetails;

    private StatusDetails(BuilderImpl builder) {
        this.validationDetails = builder.validationDetails;
        this.dataProcessingDetails = builder.dataProcessingDetails;
        this.trainingDetails = builder.trainingDetails;
    }

    public final ValidationDetails validationDetails() {
        return this.validationDetails;
    }

    public final DataProcessingDetails dataProcessingDetails() {
        return this.dataProcessingDetails;
    }

    public final TrainingDetails trainingDetails() {
        return this.trainingDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProcessingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetails)) {
            return false;
        }
        StatusDetails other = (StatusDetails)obj;
        return Objects.equals(this.validationDetails(), other.validationDetails()) && Objects.equals(this.dataProcessingDetails(), other.dataProcessingDetails()) && Objects.equals(this.trainingDetails(), other.trainingDetails());
    }

    public final String toString() {
        return ToString.builder((String)"StatusDetails").add("ValidationDetails", (Object)this.validationDetails()).add("DataProcessingDetails", (Object)this.dataProcessingDetails()).add("TrainingDetails", (Object)this.trainingDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationDetails": {
                return Optional.ofNullable(clazz.cast(this.validationDetails()));
            }
            case "dataProcessingDetails": {
                return Optional.ofNullable(clazz.cast(this.dataProcessingDetails()));
            }
            case "trainingDetails": {
                return Optional.ofNullable(clazz.cast(this.trainingDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validationDetails", VALIDATION_DETAILS_FIELD);
        map.put("dataProcessingDetails", DATA_PROCESSING_DETAILS_FIELD);
        map.put("trainingDetails", TRAINING_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatusDetails, T> g) {
        return obj -> g.apply((StatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ValidationDetails validationDetails;
        private DataProcessingDetails dataProcessingDetails;
        private TrainingDetails trainingDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetails model) {
            this.validationDetails(model.validationDetails);
            this.dataProcessingDetails(model.dataProcessingDetails);
            this.trainingDetails(model.trainingDetails);
        }

        public final ValidationDetails.Builder getValidationDetails() {
            return this.validationDetails != null ? this.validationDetails.toBuilder() : null;
        }

        public final void setValidationDetails(ValidationDetails.BuilderImpl validationDetails) {
            this.validationDetails = validationDetails != null ? validationDetails.build() : null;
        }

        @Override
        public final Builder validationDetails(ValidationDetails validationDetails) {
            this.validationDetails = validationDetails;
            return this;
        }

        public final DataProcessingDetails.Builder getDataProcessingDetails() {
            return this.dataProcessingDetails != null ? this.dataProcessingDetails.toBuilder() : null;
        }

        public final void setDataProcessingDetails(DataProcessingDetails.BuilderImpl dataProcessingDetails) {
            this.dataProcessingDetails = dataProcessingDetails != null ? dataProcessingDetails.build() : null;
        }

        @Override
        public final Builder dataProcessingDetails(DataProcessingDetails dataProcessingDetails) {
            this.dataProcessingDetails = dataProcessingDetails;
            return this;
        }

        public final TrainingDetails.Builder getTrainingDetails() {
            return this.trainingDetails != null ? this.trainingDetails.toBuilder() : null;
        }

        public final void setTrainingDetails(TrainingDetails.BuilderImpl trainingDetails) {
            this.trainingDetails = trainingDetails != null ? trainingDetails.build() : null;
        }

        @Override
        public final Builder trainingDetails(TrainingDetails trainingDetails) {
            this.trainingDetails = trainingDetails;
            return this;
        }

        public StatusDetails build() {
            return new StatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatusDetails> {
        public Builder validationDetails(ValidationDetails var1);

        default public Builder validationDetails(Consumer<ValidationDetails.Builder> validationDetails) {
            return this.validationDetails((ValidationDetails)((ValidationDetails.Builder)ValidationDetails.builder().applyMutation(validationDetails)).build());
        }

        public Builder dataProcessingDetails(DataProcessingDetails var1);

        default public Builder dataProcessingDetails(Consumer<DataProcessingDetails.Builder> dataProcessingDetails) {
            return this.dataProcessingDetails((DataProcessingDetails)((DataProcessingDetails.Builder)DataProcessingDetails.builder().applyMutation(dataProcessingDetails)).build());
        }

        public Builder trainingDetails(TrainingDetails var1);

        default public Builder trainingDetails(Consumer<TrainingDetails.Builder> trainingDetails) {
            return this.trainingDetails((TrainingDetails)((TrainingDetails.Builder)TrainingDetails.builder().applyMutation(trainingDetails)).build());
        }
    }
}

