/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.ModelDataSource;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomModelRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateCustomModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(CreateCustomModelRequest.getter(CreateCustomModelRequest::modelName)).setter(CreateCustomModelRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelSourceConfig").getter(CreateCustomModelRequest.getter(CreateCustomModelRequest::modelSourceConfig)).setter(CreateCustomModelRequest.setter(Builder::modelSourceConfig)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSourceConfig").build()}).build();
    private static final SdkField<String> MODEL_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelKmsKeyArn").getter(CreateCustomModelRequest.getter(CreateCustomModelRequest::modelKmsKeyArn)).setter(CreateCustomModelRequest.setter(Builder::modelKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateCustomModelRequest.getter(CreateCustomModelRequest::roleArn)).setter(CreateCustomModelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> MODEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelTags").getter(CreateCustomModelRequest.getter(CreateCustomModelRequest::modelTags)).setter(CreateCustomModelRequest.setter(Builder::modelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateCustomModelRequest.getter(CreateCustomModelRequest::clientRequestToken)).setter(CreateCustomModelRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_SOURCE_CONFIG_FIELD, MODEL_KMS_KEY_ARN_FIELD, ROLE_ARN_FIELD, MODEL_TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCustomModelRequest.memberNameToFieldInitializer();
    private final String modelName;
    private final ModelDataSource modelSourceConfig;
    private final String modelKmsKeyArn;
    private final String roleArn;
    private final List<Tag> modelTags;
    private final String clientRequestToken;

    private CreateCustomModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelSourceConfig = builder.modelSourceConfig;
        this.modelKmsKeyArn = builder.modelKmsKeyArn;
        this.roleArn = builder.roleArn;
        this.modelTags = builder.modelTags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final ModelDataSource modelSourceConfig() {
        return this.modelSourceConfig;
    }

    public final String modelKmsKeyArn() {
        return this.modelKmsKeyArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasModelTags() {
        return this.modelTags != null && !(this.modelTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> modelTags() {
        return this.modelTags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelTags() ? this.modelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomModelRequest)) {
            return false;
        }
        CreateCustomModelRequest other = (CreateCustomModelRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelSourceConfig(), other.modelSourceConfig()) && Objects.equals(this.modelKmsKeyArn(), other.modelKmsKeyArn()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasModelTags() == other.hasModelTags() && Objects.equals(this.modelTags(), other.modelTags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomModelRequest").add("ModelName", (Object)this.modelName()).add("ModelSourceConfig", (Object)this.modelSourceConfig()).add("ModelKmsKeyArn", (Object)this.modelKmsKeyArn()).add("RoleArn", (Object)this.roleArn()).add("ModelTags", this.hasModelTags() ? this.modelTags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "modelSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.modelSourceConfig()));
            }
            case "modelKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.modelKmsKeyArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "modelTags": {
                return Optional.ofNullable(clazz.cast(this.modelTags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelName", MODEL_NAME_FIELD);
        map.put("modelSourceConfig", MODEL_SOURCE_CONFIG_FIELD);
        map.put("modelKmsKeyArn", MODEL_KMS_KEY_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("modelTags", MODEL_TAGS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomModelRequest, T> g) {
        return obj -> g.apply((CreateCustomModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private ModelDataSource modelSourceConfig;
        private String modelKmsKeyArn;
        private String roleArn;
        private List<Tag> modelTags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomModelRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.modelSourceConfig(model.modelSourceConfig);
            this.modelKmsKeyArn(model.modelKmsKeyArn);
            this.roleArn(model.roleArn);
            this.modelTags(model.modelTags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final ModelDataSource.Builder getModelSourceConfig() {
            return this.modelSourceConfig != null ? this.modelSourceConfig.toBuilder() : null;
        }

        public final void setModelSourceConfig(ModelDataSource.BuilderImpl modelSourceConfig) {
            this.modelSourceConfig = modelSourceConfig != null ? modelSourceConfig.build() : null;
        }

        @Override
        public final Builder modelSourceConfig(ModelDataSource modelSourceConfig) {
            this.modelSourceConfig = modelSourceConfig;
            return this;
        }

        public final String getModelKmsKeyArn() {
            return this.modelKmsKeyArn;
        }

        public final void setModelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
        }

        @Override
        public final Builder modelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.modelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelTags(Collection<Tag.BuilderImpl> modelTags) {
            this.modelTags = TagListCopier.copyFromBuilder(modelTags);
        }

        @Override
        public final Builder modelTags(Collection<Tag> modelTags) {
            this.modelTags = TagListCopier.copy(modelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelTags(Tag ... modelTags) {
            this.modelTags(Arrays.asList(modelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelTags(Consumer<Tag.Builder> ... modelTags) {
            this.modelTags(Stream.of(modelTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomModelRequest build() {
            return new CreateCustomModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomModelRequest> {
        public Builder modelName(String var1);

        public Builder modelSourceConfig(ModelDataSource var1);

        default public Builder modelSourceConfig(Consumer<ModelDataSource.Builder> modelSourceConfig) {
            return this.modelSourceConfig((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelSourceConfig)).build());
        }

        public Builder modelKmsKeyArn(String var1);

        public Builder roleArn(String var1);

        public Builder modelTags(Collection<Tag> var1);

        public Builder modelTags(Tag ... var1);

        public Builder modelTags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

