/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.Validator;
import software.amazon.awssdk.services.bedrock.model.ValidatorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationDataConfig> {
    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validators").getter(ValidationDataConfig.getter(ValidationDataConfig::validators)).setter(ValidationDataConfig.setter(Builder::validators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Validator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationDataConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Validator> validators;

    private ValidationDataConfig(BuilderImpl builder) {
        this.validators = builder.validators;
    }

    public final boolean hasValidators() {
        return this.validators != null && !(this.validators instanceof SdkAutoConstructList);
    }

    public final List<Validator> validators() {
        return this.validators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidators() ? this.validators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationDataConfig)) {
            return false;
        }
        ValidationDataConfig other = (ValidationDataConfig)obj;
        return this.hasValidators() == other.hasValidators() && Objects.equals(this.validators(), other.validators());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationDataConfig").add("Validators", this.hasValidators() ? this.validators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validators": {
                return Optional.ofNullable(clazz.cast(this.validators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Validator>>> map = new HashMap<String, SdkField<List<Validator>>>();
        map.put("validators", VALIDATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationDataConfig, T> g) {
        return obj -> g.apply((ValidationDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationDataConfig model) {
            this.validators(model.validators);
        }

        public final List<Validator.Builder> getValidators() {
            List<Validator.Builder> result = ValidatorsCopier.copyToBuilder(this.validators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorsCopier.copyFromBuilder(validators);
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorsCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator ... validators) {
            this.validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder> ... validators) {
            this.validators(Stream.of(validators).map(c -> (Validator)((Validator.Builder)Validator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ValidationDataConfig build() {
            return new ValidationDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationDataConfig> {
        public Builder validators(Collection<Validator> var1);

        public Builder validators(Validator ... var1);

        public Builder validators(Consumer<Validator.Builder> ... var1);
    }
}

