/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckResult;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRuleIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyScenario
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyScenario> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(AutomatedReasoningPolicyScenario.getter(AutomatedReasoningPolicyScenario::expression)).setter(AutomatedReasoningPolicyScenario.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<String> ALTERNATE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alternateExpression").getter(AutomatedReasoningPolicyScenario.getter(AutomatedReasoningPolicyScenario::alternateExpression)).setter(AutomatedReasoningPolicyScenario.setter(Builder::alternateExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateExpression").build()}).build();
    private static final SdkField<String> EXPECTED_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedResult").getter(AutomatedReasoningPolicyScenario.getter(AutomatedReasoningPolicyScenario::expectedResultAsString)).setter(AutomatedReasoningPolicyScenario.setter(Builder::expectedResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedResult").build()}).build();
    private static final SdkField<List<String>> RULE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleIds").getter(AutomatedReasoningPolicyScenario.getter(AutomatedReasoningPolicyScenario::ruleIds)).setter(AutomatedReasoningPolicyScenario.setter(Builder::ruleIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, ALTERNATE_EXPRESSION_FIELD, EXPECTED_RESULT_FIELD, RULE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyScenario.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String alternateExpression;
    private final String expectedResult;
    private final List<String> ruleIds;

    private AutomatedReasoningPolicyScenario(BuilderImpl builder) {
        this.expression = builder.expression;
        this.alternateExpression = builder.alternateExpression;
        this.expectedResult = builder.expectedResult;
        this.ruleIds = builder.ruleIds;
    }

    public final String expression() {
        return this.expression;
    }

    public final String alternateExpression() {
        return this.alternateExpression;
    }

    public final AutomatedReasoningCheckResult expectedResult() {
        return AutomatedReasoningCheckResult.fromValue(this.expectedResult);
    }

    public final String expectedResultAsString() {
        return this.expectedResult;
    }

    public final boolean hasRuleIds() {
        return this.ruleIds != null && !(this.ruleIds instanceof SdkAutoConstructList);
    }

    public final List<String> ruleIds() {
        return this.ruleIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleIds() ? this.ruleIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyScenario)) {
            return false;
        }
        AutomatedReasoningPolicyScenario other = (AutomatedReasoningPolicyScenario)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.alternateExpression(), other.alternateExpression()) && Objects.equals(this.expectedResultAsString(), other.expectedResultAsString()) && this.hasRuleIds() == other.hasRuleIds() && Objects.equals(this.ruleIds(), other.ruleIds());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyScenario").add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("AlternateExpression", (Object)(this.alternateExpression() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpectedResult", (Object)this.expectedResultAsString()).add("RuleIds", this.hasRuleIds() ? this.ruleIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "alternateExpression": {
                return Optional.ofNullable(clazz.cast(this.alternateExpression()));
            }
            case "expectedResult": {
                return Optional.ofNullable(clazz.cast(this.expectedResultAsString()));
            }
            case "ruleIds": {
                return Optional.ofNullable(clazz.cast(this.ruleIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("alternateExpression", ALTERNATE_EXPRESSION_FIELD);
        map.put("expectedResult", EXPECTED_RESULT_FIELD);
        map.put("ruleIds", RULE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyScenario, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyScenario)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private String alternateExpression;
        private String expectedResult;
        private List<String> ruleIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyScenario model) {
            this.expression(model.expression);
            this.alternateExpression(model.alternateExpression);
            this.expectedResult(model.expectedResult);
            this.ruleIds(model.ruleIds);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getAlternateExpression() {
            return this.alternateExpression;
        }

        public final void setAlternateExpression(String alternateExpression) {
            this.alternateExpression = alternateExpression;
        }

        @Override
        public final Builder alternateExpression(String alternateExpression) {
            this.alternateExpression = alternateExpression;
            return this;
        }

        public final String getExpectedResult() {
            return this.expectedResult;
        }

        public final void setExpectedResult(String expectedResult) {
            this.expectedResult = expectedResult;
        }

        @Override
        public final Builder expectedResult(String expectedResult) {
            this.expectedResult = expectedResult;
            return this;
        }

        @Override
        public final Builder expectedResult(AutomatedReasoningCheckResult expectedResult) {
            this.expectedResult(expectedResult == null ? null : expectedResult.toString());
            return this;
        }

        public final Collection<String> getRuleIds() {
            if (this.ruleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleIds;
        }

        public final void setRuleIds(Collection<String> ruleIds) {
            this.ruleIds = AutomatedReasoningPolicyDefinitionRuleIdListCopier.copy(ruleIds);
        }

        @Override
        public final Builder ruleIds(Collection<String> ruleIds) {
            this.ruleIds = AutomatedReasoningPolicyDefinitionRuleIdListCopier.copy(ruleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleIds(String ... ruleIds) {
            this.ruleIds(Arrays.asList(ruleIds));
            return this;
        }

        public AutomatedReasoningPolicyScenario build() {
            return new AutomatedReasoningPolicyScenario(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyScenario> {
        public Builder expression(String var1);

        public Builder alternateExpression(String var1);

        public Builder expectedResult(String var1);

        public Builder expectedResult(AutomatedReasoningCheckResult var1);

        public Builder ruleIds(Collection<String> var1);

        public Builder ruleIds(String ... var1);
    }
}

