/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicsConfigCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicsTierConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTopicPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTopicPolicyConfig> {
    private static final SdkField<List<GuardrailTopicConfig>> TOPICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topicsConfig").getter(GuardrailTopicPolicyConfig.getter(GuardrailTopicPolicyConfig::topicsConfig)).setter(GuardrailTopicPolicyConfig.setter(Builder::topicsConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailTopicConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GuardrailTopicsTierConfig> TIER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tierConfig").getter(GuardrailTopicPolicyConfig.getter(GuardrailTopicPolicyConfig::tierConfig)).setter(GuardrailTopicPolicyConfig.setter(Builder::tierConfig)).constructor(GuardrailTopicsTierConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tierConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPICS_CONFIG_FIELD, TIER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailTopicPolicyConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailTopicConfig> topicsConfig;
    private final GuardrailTopicsTierConfig tierConfig;

    private GuardrailTopicPolicyConfig(BuilderImpl builder) {
        this.topicsConfig = builder.topicsConfig;
        this.tierConfig = builder.tierConfig;
    }

    public final boolean hasTopicsConfig() {
        return this.topicsConfig != null && !(this.topicsConfig instanceof SdkAutoConstructList);
    }

    public final List<GuardrailTopicConfig> topicsConfig() {
        return this.topicsConfig;
    }

    public final GuardrailTopicsTierConfig tierConfig() {
        return this.tierConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicsConfig() ? this.topicsConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicPolicyConfig)) {
            return false;
        }
        GuardrailTopicPolicyConfig other = (GuardrailTopicPolicyConfig)obj;
        return this.hasTopicsConfig() == other.hasTopicsConfig() && Objects.equals(this.topicsConfig(), other.topicsConfig()) && Objects.equals(this.tierConfig(), other.tierConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTopicPolicyConfig").add("TopicsConfig", this.hasTopicsConfig() ? this.topicsConfig() : null).add("TierConfig", (Object)this.tierConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topicsConfig": {
                return Optional.ofNullable(clazz.cast(this.topicsConfig()));
            }
            case "tierConfig": {
                return Optional.ofNullable(clazz.cast(this.tierConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("topicsConfig", TOPICS_CONFIG_FIELD);
        map.put("tierConfig", TIER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopicPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailTopicPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailTopicConfig> topicsConfig = DefaultSdkAutoConstructList.getInstance();
        private GuardrailTopicsTierConfig tierConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopicPolicyConfig model) {
            this.topicsConfig(model.topicsConfig);
            this.tierConfig(model.tierConfig);
        }

        public final List<GuardrailTopicConfig.Builder> getTopicsConfig() {
            List<GuardrailTopicConfig.Builder> result = GuardrailTopicsConfigCopier.copyToBuilder(this.topicsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicsConfig(Collection<GuardrailTopicConfig.BuilderImpl> topicsConfig) {
            this.topicsConfig = GuardrailTopicsConfigCopier.copyFromBuilder(topicsConfig);
        }

        @Override
        public final Builder topicsConfig(Collection<GuardrailTopicConfig> topicsConfig) {
            this.topicsConfig = GuardrailTopicsConfigCopier.copy(topicsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsConfig(GuardrailTopicConfig ... topicsConfig) {
            this.topicsConfig(Arrays.asList(topicsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsConfig(Consumer<GuardrailTopicConfig.Builder> ... topicsConfig) {
            this.topicsConfig(Stream.of(topicsConfig).map(c -> (GuardrailTopicConfig)((GuardrailTopicConfig.Builder)GuardrailTopicConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailTopicsTierConfig.Builder getTierConfig() {
            return this.tierConfig != null ? this.tierConfig.toBuilder() : null;
        }

        public final void setTierConfig(GuardrailTopicsTierConfig.BuilderImpl tierConfig) {
            this.tierConfig = tierConfig != null ? tierConfig.build() : null;
        }

        @Override
        public final Builder tierConfig(GuardrailTopicsTierConfig tierConfig) {
            this.tierConfig = tierConfig;
            return this;
        }

        public GuardrailTopicPolicyConfig build() {
            return new GuardrailTopicPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTopicPolicyConfig> {
        public Builder topicsConfig(Collection<GuardrailTopicConfig> var1);

        public Builder topicsConfig(GuardrailTopicConfig ... var1);

        public Builder topicsConfig(Consumer<GuardrailTopicConfig.Builder> ... var1);

        public Builder tierConfig(GuardrailTopicsTierConfig var1);

        default public Builder tierConfig(Consumer<GuardrailTopicsTierConfig.Builder> tierConfig) {
            return this.tierConfig((GuardrailTopicsTierConfig)((GuardrailTopicsTierConfig.Builder)GuardrailTopicsTierConfig.builder().applyMutation(tierConfig)).build());
        }
    }
}

