/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.InputTags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountEnforcedGuardrailInferenceInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountEnforcedGuardrailInferenceInputConfiguration> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailIdentifier").getter(AccountEnforcedGuardrailInferenceInputConfiguration.getter(AccountEnforcedGuardrailInferenceInputConfiguration::guardrailIdentifier)).setter(AccountEnforcedGuardrailInferenceInputConfiguration.setter(Builder::guardrailIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailIdentifier").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(AccountEnforcedGuardrailInferenceInputConfiguration.getter(AccountEnforcedGuardrailInferenceInputConfiguration::guardrailVersion)).setter(AccountEnforcedGuardrailInferenceInputConfiguration.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()}).build();
    private static final SdkField<String> INPUT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputTags").getter(AccountEnforcedGuardrailInferenceInputConfiguration.getter(AccountEnforcedGuardrailInferenceInputConfiguration::inputTagsAsString)).setter(AccountEnforcedGuardrailInferenceInputConfiguration.setter(Builder::inputTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD, GUARDRAIL_VERSION_FIELD, INPUT_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountEnforcedGuardrailInferenceInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String guardrailIdentifier;
    private final String guardrailVersion;
    private final String inputTags;

    private AccountEnforcedGuardrailInferenceInputConfiguration(BuilderImpl builder) {
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.inputTags = builder.inputTags;
    }

    public final String guardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public final InputTags inputTags() {
        return InputTags.fromValue(this.inputTags);
    }

    public final String inputTagsAsString() {
        return this.inputTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTagsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEnforcedGuardrailInferenceInputConfiguration)) {
            return false;
        }
        AccountEnforcedGuardrailInferenceInputConfiguration other = (AccountEnforcedGuardrailInferenceInputConfiguration)obj;
        return Objects.equals(this.guardrailIdentifier(), other.guardrailIdentifier()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion()) && Objects.equals(this.inputTagsAsString(), other.inputTagsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccountEnforcedGuardrailInferenceInputConfiguration").add("GuardrailIdentifier", (Object)this.guardrailIdentifier()).add("GuardrailVersion", (Object)this.guardrailVersion()).add("InputTags", (Object)this.inputTagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailIdentifier": {
                return Optional.ofNullable(clazz.cast(this.guardrailIdentifier()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
            case "inputTags": {
                return Optional.ofNullable(clazz.cast(this.inputTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("inputTags", INPUT_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountEnforcedGuardrailInferenceInputConfiguration, T> g) {
        return obj -> g.apply((AccountEnforcedGuardrailInferenceInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String guardrailIdentifier;
        private String guardrailVersion;
        private String inputTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountEnforcedGuardrailInferenceInputConfiguration model) {
            this.guardrailIdentifier(model.guardrailIdentifier);
            this.guardrailVersion(model.guardrailVersion);
            this.inputTags(model.inputTags);
        }

        public final String getGuardrailIdentifier() {
            return this.guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getInputTags() {
            return this.inputTags;
        }

        public final void setInputTags(String inputTags) {
            this.inputTags = inputTags;
        }

        @Override
        public final Builder inputTags(String inputTags) {
            this.inputTags = inputTags;
            return this;
        }

        @Override
        public final Builder inputTags(InputTags inputTags) {
            this.inputTags(inputTags == null ? null : inputTags.toString());
            return this;
        }

        public AccountEnforcedGuardrailInferenceInputConfiguration build() {
            return new AccountEnforcedGuardrailInferenceInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountEnforcedGuardrailInferenceInputConfiguration> {
        public Builder guardrailIdentifier(String var1);

        public Builder guardrailVersion(String var1);

        public Builder inputTags(String var1);

        public Builder inputTags(InputTags var1);
    }
}

