/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildLog;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinition;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionQualityReport;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyGeneratedTestCases;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyScenarios;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyBuildResultAssets
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyBuildResultAssets> {
    private static final SdkField<AutomatedReasoningPolicyDefinition> POLICY_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policyDefinition").getter(AutomatedReasoningPolicyBuildResultAssets.getter(AutomatedReasoningPolicyBuildResultAssets::policyDefinition)).setter(AutomatedReasoningPolicyBuildResultAssets.setter(Builder::policyDefinition)).constructor(AutomatedReasoningPolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinition").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyDefinitionQualityReport> QUALITY_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qualityReport").getter(AutomatedReasoningPolicyBuildResultAssets.getter(AutomatedReasoningPolicyBuildResultAssets::qualityReport)).setter(AutomatedReasoningPolicyBuildResultAssets.setter(Builder::qualityReport)).constructor(AutomatedReasoningPolicyDefinitionQualityReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityReport").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyBuildLog> BUILD_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("buildLog").getter(AutomatedReasoningPolicyBuildResultAssets.getter(AutomatedReasoningPolicyBuildResultAssets::buildLog)).setter(AutomatedReasoningPolicyBuildResultAssets.setter(Builder::buildLog)).constructor(AutomatedReasoningPolicyBuildLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildLog").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyGeneratedTestCases> GENERATED_TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generatedTestCases").getter(AutomatedReasoningPolicyBuildResultAssets.getter(AutomatedReasoningPolicyBuildResultAssets::generatedTestCases)).setter(AutomatedReasoningPolicyBuildResultAssets.setter(Builder::generatedTestCases)).constructor(AutomatedReasoningPolicyGeneratedTestCases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedTestCases").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyScenarios> POLICY_SCENARIOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policyScenarios").getter(AutomatedReasoningPolicyBuildResultAssets.getter(AutomatedReasoningPolicyBuildResultAssets::policyScenarios)).setter(AutomatedReasoningPolicyBuildResultAssets.setter(Builder::policyScenarios)).constructor(AutomatedReasoningPolicyScenarios::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyScenarios").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DEFINITION_FIELD, QUALITY_REPORT_FIELD, BUILD_LOG_FIELD, GENERATED_TEST_CASES_FIELD, POLICY_SCENARIOS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyBuildResultAssets.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningPolicyDefinition policyDefinition;
    private final AutomatedReasoningPolicyDefinitionQualityReport qualityReport;
    private final AutomatedReasoningPolicyBuildLog buildLog;
    private final AutomatedReasoningPolicyGeneratedTestCases generatedTestCases;
    private final AutomatedReasoningPolicyScenarios policyScenarios;
    private final Type type;

    private AutomatedReasoningPolicyBuildResultAssets(BuilderImpl builder) {
        this.policyDefinition = builder.policyDefinition;
        this.qualityReport = builder.qualityReport;
        this.buildLog = builder.buildLog;
        this.generatedTestCases = builder.generatedTestCases;
        this.policyScenarios = builder.policyScenarios;
        this.type = builder.type;
    }

    public final AutomatedReasoningPolicyDefinition policyDefinition() {
        return this.policyDefinition;
    }

    public final AutomatedReasoningPolicyDefinitionQualityReport qualityReport() {
        return this.qualityReport;
    }

    public final AutomatedReasoningPolicyBuildLog buildLog() {
        return this.buildLog;
    }

    public final AutomatedReasoningPolicyGeneratedTestCases generatedTestCases() {
        return this.generatedTestCases;
    }

    public final AutomatedReasoningPolicyScenarios policyScenarios() {
        return this.policyScenarios;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTestCases());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyScenarios());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildResultAssets)) {
            return false;
        }
        AutomatedReasoningPolicyBuildResultAssets other = (AutomatedReasoningPolicyBuildResultAssets)obj;
        return Objects.equals(this.policyDefinition(), other.policyDefinition()) && Objects.equals(this.qualityReport(), other.qualityReport()) && Objects.equals(this.buildLog(), other.buildLog()) && Objects.equals(this.generatedTestCases(), other.generatedTestCases()) && Objects.equals(this.policyScenarios(), other.policyScenarios());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyBuildResultAssets").add("PolicyDefinition", (Object)this.policyDefinition()).add("QualityReport", (Object)this.qualityReport()).add("BuildLog", (Object)this.buildLog()).add("GeneratedTestCases", (Object)this.generatedTestCases()).add("PolicyScenarios", (Object)this.policyScenarios()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyDefinition": {
                return Optional.ofNullable(clazz.cast(this.policyDefinition()));
            }
            case "qualityReport": {
                return Optional.ofNullable(clazz.cast(this.qualityReport()));
            }
            case "buildLog": {
                return Optional.ofNullable(clazz.cast(this.buildLog()));
            }
            case "generatedTestCases": {
                return Optional.ofNullable(clazz.cast(this.generatedTestCases()));
            }
            case "policyScenarios": {
                return Optional.ofNullable(clazz.cast(this.policyScenarios()));
            }
        }
        return Optional.empty();
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromPolicyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
        return (AutomatedReasoningPolicyBuildResultAssets)AutomatedReasoningPolicyBuildResultAssets.builder().policyDefinition(policyDefinition).build();
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromPolicyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
        AutomatedReasoningPolicyDefinition.Builder builder = AutomatedReasoningPolicyDefinition.builder();
        policyDefinition.accept(builder);
        return AutomatedReasoningPolicyBuildResultAssets.fromPolicyDefinition((AutomatedReasoningPolicyDefinition)builder.build());
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromQualityReport(AutomatedReasoningPolicyDefinitionQualityReport qualityReport) {
        return (AutomatedReasoningPolicyBuildResultAssets)AutomatedReasoningPolicyBuildResultAssets.builder().qualityReport(qualityReport).build();
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromQualityReport(Consumer<AutomatedReasoningPolicyDefinitionQualityReport.Builder> qualityReport) {
        AutomatedReasoningPolicyDefinitionQualityReport.Builder builder = AutomatedReasoningPolicyDefinitionQualityReport.builder();
        qualityReport.accept(builder);
        return AutomatedReasoningPolicyBuildResultAssets.fromQualityReport((AutomatedReasoningPolicyDefinitionQualityReport)builder.build());
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromBuildLog(AutomatedReasoningPolicyBuildLog buildLog) {
        return (AutomatedReasoningPolicyBuildResultAssets)AutomatedReasoningPolicyBuildResultAssets.builder().buildLog(buildLog).build();
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromBuildLog(Consumer<AutomatedReasoningPolicyBuildLog.Builder> buildLog) {
        AutomatedReasoningPolicyBuildLog.Builder builder = AutomatedReasoningPolicyBuildLog.builder();
        buildLog.accept(builder);
        return AutomatedReasoningPolicyBuildResultAssets.fromBuildLog((AutomatedReasoningPolicyBuildLog)builder.build());
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromGeneratedTestCases(AutomatedReasoningPolicyGeneratedTestCases generatedTestCases) {
        return (AutomatedReasoningPolicyBuildResultAssets)AutomatedReasoningPolicyBuildResultAssets.builder().generatedTestCases(generatedTestCases).build();
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromGeneratedTestCases(Consumer<AutomatedReasoningPolicyGeneratedTestCases.Builder> generatedTestCases) {
        AutomatedReasoningPolicyGeneratedTestCases.Builder builder = AutomatedReasoningPolicyGeneratedTestCases.builder();
        generatedTestCases.accept(builder);
        return AutomatedReasoningPolicyBuildResultAssets.fromGeneratedTestCases((AutomatedReasoningPolicyGeneratedTestCases)builder.build());
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromPolicyScenarios(AutomatedReasoningPolicyScenarios policyScenarios) {
        return (AutomatedReasoningPolicyBuildResultAssets)AutomatedReasoningPolicyBuildResultAssets.builder().policyScenarios(policyScenarios).build();
    }

    public static AutomatedReasoningPolicyBuildResultAssets fromPolicyScenarios(Consumer<AutomatedReasoningPolicyScenarios.Builder> policyScenarios) {
        AutomatedReasoningPolicyScenarios.Builder builder = AutomatedReasoningPolicyScenarios.builder();
        policyScenarios.accept(builder);
        return AutomatedReasoningPolicyBuildResultAssets.fromPolicyScenarios((AutomatedReasoningPolicyScenarios)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyDefinition", POLICY_DEFINITION_FIELD);
        map.put("qualityReport", QUALITY_REPORT_FIELD);
        map.put("buildLog", BUILD_LOG_FIELD);
        map.put("generatedTestCases", GENERATED_TEST_CASES_FIELD);
        map.put("policyScenarios", POLICY_SCENARIOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildResultAssets, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildResultAssets)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        POLICY_DEFINITION,
        QUALITY_REPORT,
        BUILD_LOG,
        GENERATED_TEST_CASES,
        POLICY_SCENARIOS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningPolicyDefinition policyDefinition;
        private AutomatedReasoningPolicyDefinitionQualityReport qualityReport;
        private AutomatedReasoningPolicyBuildLog buildLog;
        private AutomatedReasoningPolicyGeneratedTestCases generatedTestCases;
        private AutomatedReasoningPolicyScenarios policyScenarios;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildResultAssets model) {
            this.policyDefinition(model.policyDefinition);
            this.qualityReport(model.qualityReport);
            this.buildLog(model.buildLog);
            this.generatedTestCases(model.generatedTestCases);
            this.policyScenarios(model.policyScenarios);
        }

        public final AutomatedReasoningPolicyDefinition.Builder getPolicyDefinition() {
            return this.policyDefinition != null ? this.policyDefinition.toBuilder() : null;
        }

        public final void setPolicyDefinition(AutomatedReasoningPolicyDefinition.BuilderImpl policyDefinition) {
            AutomatedReasoningPolicyDefinition oldValue = this.policyDefinition;
            this.policyDefinition = policyDefinition != null ? policyDefinition.build() : null;
            this.handleUnionValueChange(Type.POLICY_DEFINITION, oldValue, this.policyDefinition);
        }

        @Override
        public final Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
            AutomatedReasoningPolicyDefinition oldValue = this.policyDefinition;
            this.policyDefinition = policyDefinition;
            this.handleUnionValueChange(Type.POLICY_DEFINITION, oldValue, this.policyDefinition);
            return this;
        }

        public final AutomatedReasoningPolicyDefinitionQualityReport.Builder getQualityReport() {
            return this.qualityReport != null ? this.qualityReport.toBuilder() : null;
        }

        public final void setQualityReport(AutomatedReasoningPolicyDefinitionQualityReport.BuilderImpl qualityReport) {
            AutomatedReasoningPolicyDefinitionQualityReport oldValue = this.qualityReport;
            this.qualityReport = qualityReport != null ? qualityReport.build() : null;
            this.handleUnionValueChange(Type.QUALITY_REPORT, oldValue, this.qualityReport);
        }

        @Override
        public final Builder qualityReport(AutomatedReasoningPolicyDefinitionQualityReport qualityReport) {
            AutomatedReasoningPolicyDefinitionQualityReport oldValue = this.qualityReport;
            this.qualityReport = qualityReport;
            this.handleUnionValueChange(Type.QUALITY_REPORT, oldValue, this.qualityReport);
            return this;
        }

        public final AutomatedReasoningPolicyBuildLog.Builder getBuildLog() {
            return this.buildLog != null ? this.buildLog.toBuilder() : null;
        }

        public final void setBuildLog(AutomatedReasoningPolicyBuildLog.BuilderImpl buildLog) {
            AutomatedReasoningPolicyBuildLog oldValue = this.buildLog;
            this.buildLog = buildLog != null ? buildLog.build() : null;
            this.handleUnionValueChange(Type.BUILD_LOG, oldValue, this.buildLog);
        }

        @Override
        public final Builder buildLog(AutomatedReasoningPolicyBuildLog buildLog) {
            AutomatedReasoningPolicyBuildLog oldValue = this.buildLog;
            this.buildLog = buildLog;
            this.handleUnionValueChange(Type.BUILD_LOG, oldValue, this.buildLog);
            return this;
        }

        public final AutomatedReasoningPolicyGeneratedTestCases.Builder getGeneratedTestCases() {
            return this.generatedTestCases != null ? this.generatedTestCases.toBuilder() : null;
        }

        public final void setGeneratedTestCases(AutomatedReasoningPolicyGeneratedTestCases.BuilderImpl generatedTestCases) {
            AutomatedReasoningPolicyGeneratedTestCases oldValue = this.generatedTestCases;
            this.generatedTestCases = generatedTestCases != null ? generatedTestCases.build() : null;
            this.handleUnionValueChange(Type.GENERATED_TEST_CASES, oldValue, this.generatedTestCases);
        }

        @Override
        public final Builder generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases generatedTestCases) {
            AutomatedReasoningPolicyGeneratedTestCases oldValue = this.generatedTestCases;
            this.generatedTestCases = generatedTestCases;
            this.handleUnionValueChange(Type.GENERATED_TEST_CASES, oldValue, this.generatedTestCases);
            return this;
        }

        public final AutomatedReasoningPolicyScenarios.Builder getPolicyScenarios() {
            return this.policyScenarios != null ? this.policyScenarios.toBuilder() : null;
        }

        public final void setPolicyScenarios(AutomatedReasoningPolicyScenarios.BuilderImpl policyScenarios) {
            AutomatedReasoningPolicyScenarios oldValue = this.policyScenarios;
            this.policyScenarios = policyScenarios != null ? policyScenarios.build() : null;
            this.handleUnionValueChange(Type.POLICY_SCENARIOS, oldValue, this.policyScenarios);
        }

        @Override
        public final Builder policyScenarios(AutomatedReasoningPolicyScenarios policyScenarios) {
            AutomatedReasoningPolicyScenarios oldValue = this.policyScenarios;
            this.policyScenarios = policyScenarios;
            this.handleUnionValueChange(Type.POLICY_SCENARIOS, oldValue, this.policyScenarios);
            return this;
        }

        public AutomatedReasoningPolicyBuildResultAssets build() {
            return new AutomatedReasoningPolicyBuildResultAssets(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyBuildResultAssets> {
        public Builder policyDefinition(AutomatedReasoningPolicyDefinition var1);

        default public Builder policyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
            return this.policyDefinition((AutomatedReasoningPolicyDefinition)((AutomatedReasoningPolicyDefinition.Builder)AutomatedReasoningPolicyDefinition.builder().applyMutation(policyDefinition)).build());
        }

        public Builder qualityReport(AutomatedReasoningPolicyDefinitionQualityReport var1);

        default public Builder qualityReport(Consumer<AutomatedReasoningPolicyDefinitionQualityReport.Builder> qualityReport) {
            return this.qualityReport((AutomatedReasoningPolicyDefinitionQualityReport)((AutomatedReasoningPolicyDefinitionQualityReport.Builder)AutomatedReasoningPolicyDefinitionQualityReport.builder().applyMutation(qualityReport)).build());
        }

        public Builder buildLog(AutomatedReasoningPolicyBuildLog var1);

        default public Builder buildLog(Consumer<AutomatedReasoningPolicyBuildLog.Builder> buildLog) {
            return this.buildLog((AutomatedReasoningPolicyBuildLog)((AutomatedReasoningPolicyBuildLog.Builder)AutomatedReasoningPolicyBuildLog.builder().applyMutation(buildLog)).build());
        }

        public Builder generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases var1);

        default public Builder generatedTestCases(Consumer<AutomatedReasoningPolicyGeneratedTestCases.Builder> generatedTestCases) {
            return this.generatedTestCases((AutomatedReasoningPolicyGeneratedTestCases)((AutomatedReasoningPolicyGeneratedTestCases.Builder)AutomatedReasoningPolicyGeneratedTestCases.builder().applyMutation(generatedTestCases)).build());
        }

        public Builder policyScenarios(AutomatedReasoningPolicyScenarios var1);

        default public Builder policyScenarios(Consumer<AutomatedReasoningPolicyScenarios.Builder> policyScenarios) {
            return this.policyScenarios((AutomatedReasoningPolicyScenarios)((AutomatedReasoningPolicyScenarios.Builder)AutomatedReasoningPolicyScenarios.builder().applyMutation(policyScenarios)).build());
        }
    }
}

