/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyGeneratedTestCase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyGeneratedTestCase> {
    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryContent").getter(AutomatedReasoningPolicyGeneratedTestCase.getter(AutomatedReasoningPolicyGeneratedTestCase::queryContent)).setter(AutomatedReasoningPolicyGeneratedTestCase.setter(Builder::queryContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()}).build();
    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardContent").getter(AutomatedReasoningPolicyGeneratedTestCase.getter(AutomatedReasoningPolicyGeneratedTestCase::guardContent)).setter(AutomatedReasoningPolicyGeneratedTestCase.setter(Builder::guardContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()}).build();
    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedAggregatedFindingsResult").getter(AutomatedReasoningPolicyGeneratedTestCase.getter(AutomatedReasoningPolicyGeneratedTestCase::expectedAggregatedFindingsResultAsString)).setter(AutomatedReasoningPolicyGeneratedTestCase.setter(Builder::expectedAggregatedFindingsResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_CONTENT_FIELD, GUARD_CONTENT_FIELD, EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyGeneratedTestCase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryContent;
    private final String guardContent;
    private final String expectedAggregatedFindingsResult;

    private AutomatedReasoningPolicyGeneratedTestCase(BuilderImpl builder) {
        this.queryContent = builder.queryContent;
        this.guardContent = builder.guardContent;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
    }

    public final String queryContent() {
        return this.queryContent;
    }

    public final String guardContent() {
        return this.guardContent;
    }

    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(this.expectedAggregatedFindingsResult);
    }

    public final String expectedAggregatedFindingsResultAsString() {
        return this.expectedAggregatedFindingsResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedAggregatedFindingsResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyGeneratedTestCase)) {
            return false;
        }
        AutomatedReasoningPolicyGeneratedTestCase other = (AutomatedReasoningPolicyGeneratedTestCase)obj;
        return Objects.equals(this.queryContent(), other.queryContent()) && Objects.equals(this.guardContent(), other.guardContent()) && Objects.equals(this.expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyGeneratedTestCase").add("QueryContent", (Object)(this.queryContent() == null ? null : "*** Sensitive Data Redacted ***")).add("GuardContent", (Object)(this.guardContent() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpectedAggregatedFindingsResult", (Object)this.expectedAggregatedFindingsResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryContent": {
                return Optional.ofNullable(clazz.cast(this.queryContent()));
            }
            case "guardContent": {
                return Optional.ofNullable(clazz.cast(this.guardContent()));
            }
            case "expectedAggregatedFindingsResult": {
                return Optional.ofNullable(clazz.cast(this.expectedAggregatedFindingsResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyGeneratedTestCase, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyGeneratedTestCase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryContent;
        private String guardContent;
        private String expectedAggregatedFindingsResult;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyGeneratedTestCase model) {
            this.queryContent(model.queryContent);
            this.guardContent(model.guardContent);
            this.expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
        }

        public final String getQueryContent() {
            return this.queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final String getGuardContent() {
            return this.guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return this.expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null : expectedAggregatedFindingsResult.toString());
            return this;
        }

        public AutomatedReasoningPolicyGeneratedTestCase build() {
            return new AutomatedReasoningPolicyGeneratedTestCase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyGeneratedTestCase> {
        public Builder queryContent(String var1);

        public Builder guardContent(String var1);

        public Builder expectedAggregatedFindingsResult(String var1);

        public Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult var1);
    }
}

