/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyTestCase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyTestCase> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::testCaseId)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()}).build();
    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardContent").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::guardContent)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::guardContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()}).build();
    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryContent").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::queryContent)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::queryContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()}).build();
    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedAggregatedFindingsResult").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::expectedAggregatedFindingsResultAsString)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::expectedAggregatedFindingsResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::createdAt)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::updatedAt)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("confidenceThreshold").getter(AutomatedReasoningPolicyTestCase.getter(AutomatedReasoningPolicyTestCase::confidenceThreshold)).setter(AutomatedReasoningPolicyTestCase.setter(Builder::confidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD, GUARD_CONTENT_FIELD, QUERY_CONTENT_FIELD, EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, CONFIDENCE_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyTestCase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String testCaseId;
    private final String guardContent;
    private final String queryContent;
    private final String expectedAggregatedFindingsResult;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Double confidenceThreshold;

    private AutomatedReasoningPolicyTestCase(BuilderImpl builder) {
        this.testCaseId = builder.testCaseId;
        this.guardContent = builder.guardContent;
        this.queryContent = builder.queryContent;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.confidenceThreshold = builder.confidenceThreshold;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final String guardContent() {
        return this.guardContent;
    }

    public final String queryContent() {
        return this.queryContent;
    }

    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(this.expectedAggregatedFindingsResult);
    }

    public final String expectedAggregatedFindingsResultAsString() {
        return this.expectedAggregatedFindingsResult;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Double confidenceThreshold() {
        return this.confidenceThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedAggregatedFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyTestCase)) {
            return false;
        }
        AutomatedReasoningPolicyTestCase other = (AutomatedReasoningPolicyTestCase)obj;
        return Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.guardContent(), other.guardContent()) && Objects.equals(this.queryContent(), other.queryContent()) && Objects.equals(this.expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.confidenceThreshold(), other.confidenceThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyTestCase").add("TestCaseId", (Object)this.testCaseId()).add("GuardContent", (Object)(this.guardContent() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryContent", (Object)(this.queryContent() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpectedAggregatedFindingsResult", (Object)this.expectedAggregatedFindingsResultAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ConfidenceThreshold", (Object)this.confidenceThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "guardContent": {
                return Optional.ofNullable(clazz.cast(this.guardContent()));
            }
            case "queryContent": {
                return Optional.ofNullable(clazz.cast(this.queryContent()));
            }
            case "expectedAggregatedFindingsResult": {
                return Optional.ofNullable(clazz.cast(this.expectedAggregatedFindingsResultAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "confidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.confidenceThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyTestCase, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyTestCase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testCaseId;
        private String guardContent;
        private String queryContent;
        private String expectedAggregatedFindingsResult;
        private Instant createdAt;
        private Instant updatedAt;
        private Double confidenceThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyTestCase model) {
            this.testCaseId(model.testCaseId);
            this.guardContent(model.guardContent);
            this.queryContent(model.queryContent);
            this.expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.confidenceThreshold(model.confidenceThreshold);
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getGuardContent() {
            return this.guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getQueryContent() {
            return this.queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return this.expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null : expectedAggregatedFindingsResult.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Double getConfidenceThreshold() {
            return this.confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public AutomatedReasoningPolicyTestCase build() {
            return new AutomatedReasoningPolicyTestCase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyTestCase> {
        public Builder testCaseId(String var1);

        public Builder guardContent(String var1);

        public Builder queryContent(String var1);

        public Builder expectedAggregatedFindingsResult(String var1);

        public Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder confidenceThreshold(Double var1);
    }
}

