/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.CustomModelDeploymentSummary;
import software.amazon.awssdk.services.bedrock.model.CustomModelDeploymentSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomModelDeploymentsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListCustomModelDeploymentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCustomModelDeploymentsResponse.getter(ListCustomModelDeploymentsResponse::nextToken)).setter(ListCustomModelDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CustomModelDeploymentSummary>> MODEL_DEPLOYMENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelDeploymentSummaries").getter(ListCustomModelDeploymentsResponse.getter(ListCustomModelDeploymentsResponse::modelDeploymentSummaries)).setter(ListCustomModelDeploymentsResponse.setter(Builder::modelDeploymentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDeploymentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomModelDeploymentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_DEPLOYMENT_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCustomModelDeploymentsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CustomModelDeploymentSummary> modelDeploymentSummaries;

    private ListCustomModelDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelDeploymentSummaries = builder.modelDeploymentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelDeploymentSummaries() {
        return this.modelDeploymentSummaries != null && !(this.modelDeploymentSummaries instanceof SdkAutoConstructList);
    }

    public final List<CustomModelDeploymentSummary> modelDeploymentSummaries() {
        return this.modelDeploymentSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelDeploymentSummaries() ? this.modelDeploymentSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomModelDeploymentsResponse)) {
            return false;
        }
        ListCustomModelDeploymentsResponse other = (ListCustomModelDeploymentsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelDeploymentSummaries() == other.hasModelDeploymentSummaries() && Objects.equals(this.modelDeploymentSummaries(), other.modelDeploymentSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomModelDeploymentsResponse").add("NextToken", (Object)this.nextToken()).add("ModelDeploymentSummaries", this.hasModelDeploymentSummaries() ? this.modelDeploymentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "modelDeploymentSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelDeploymentSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("modelDeploymentSummaries", MODEL_DEPLOYMENT_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomModelDeploymentsResponse, T> g) {
        return obj -> g.apply((ListCustomModelDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CustomModelDeploymentSummary> modelDeploymentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomModelDeploymentsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelDeploymentSummaries(model.modelDeploymentSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CustomModelDeploymentSummary.Builder> getModelDeploymentSummaries() {
            List<CustomModelDeploymentSummary.Builder> result = CustomModelDeploymentSummaryListCopier.copyToBuilder(this.modelDeploymentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelDeploymentSummaries(Collection<CustomModelDeploymentSummary.BuilderImpl> modelDeploymentSummaries) {
            this.modelDeploymentSummaries = CustomModelDeploymentSummaryListCopier.copyFromBuilder(modelDeploymentSummaries);
        }

        @Override
        public final Builder modelDeploymentSummaries(Collection<CustomModelDeploymentSummary> modelDeploymentSummaries) {
            this.modelDeploymentSummaries = CustomModelDeploymentSummaryListCopier.copy(modelDeploymentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelDeploymentSummaries(CustomModelDeploymentSummary ... modelDeploymentSummaries) {
            this.modelDeploymentSummaries(Arrays.asList(modelDeploymentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelDeploymentSummaries(Consumer<CustomModelDeploymentSummary.Builder> ... modelDeploymentSummaries) {
            this.modelDeploymentSummaries(Stream.of(modelDeploymentSummaries).map(c -> (CustomModelDeploymentSummary)((CustomModelDeploymentSummary.Builder)CustomModelDeploymentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCustomModelDeploymentsResponse build() {
            return new ListCustomModelDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomModelDeploymentsResponse> {
        public Builder nextToken(String var1);

        public Builder modelDeploymentSummaries(Collection<CustomModelDeploymentSummary> var1);

        public Builder modelDeploymentSummaries(CustomModelDeploymentSummary ... var1);

        public Builder modelDeploymentSummaries(Consumer<CustomModelDeploymentSummary.Builder> ... var1);
    }
}

