/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GraderConfig;
import software.amazon.awssdk.services.bedrock.model.RFTHyperParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RFTConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RFTConfig> {
    private static final SdkField<GraderConfig> GRADER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("graderConfig").getter(RFTConfig.getter(RFTConfig::graderConfig)).setter(RFTConfig.setter(Builder::graderConfig)).constructor(GraderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graderConfig").build()}).build();
    private static final SdkField<RFTHyperParameters> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hyperParameters").getter(RFTConfig.getter(RFTConfig::hyperParameters)).setter(RFTConfig.setter(Builder::hyperParameters)).constructor(RFTHyperParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRADER_CONFIG_FIELD, HYPER_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RFTConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GraderConfig graderConfig;
    private final RFTHyperParameters hyperParameters;

    private RFTConfig(BuilderImpl builder) {
        this.graderConfig = builder.graderConfig;
        this.hyperParameters = builder.hyperParameters;
    }

    public final GraderConfig graderConfig() {
        return this.graderConfig;
    }

    public final RFTHyperParameters hyperParameters() {
        return this.hyperParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.graderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RFTConfig)) {
            return false;
        }
        RFTConfig other = (RFTConfig)obj;
        return Objects.equals(this.graderConfig(), other.graderConfig()) && Objects.equals(this.hyperParameters(), other.hyperParameters());
    }

    public final String toString() {
        return ToString.builder((String)"RFTConfig").add("GraderConfig", (Object)this.graderConfig()).add("HyperParameters", (Object)this.hyperParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graderConfig": {
                return Optional.ofNullable(clazz.cast(this.graderConfig()));
            }
            case "hyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graderConfig", GRADER_CONFIG_FIELD);
        map.put("hyperParameters", HYPER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RFTConfig, T> g) {
        return obj -> g.apply((RFTConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GraderConfig graderConfig;
        private RFTHyperParameters hyperParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RFTConfig model) {
            this.graderConfig(model.graderConfig);
            this.hyperParameters(model.hyperParameters);
        }

        public final GraderConfig.Builder getGraderConfig() {
            return this.graderConfig != null ? this.graderConfig.toBuilder() : null;
        }

        public final void setGraderConfig(GraderConfig.BuilderImpl graderConfig) {
            this.graderConfig = graderConfig != null ? graderConfig.build() : null;
        }

        @Override
        public final Builder graderConfig(GraderConfig graderConfig) {
            this.graderConfig = graderConfig;
            return this;
        }

        public final RFTHyperParameters.Builder getHyperParameters() {
            return this.hyperParameters != null ? this.hyperParameters.toBuilder() : null;
        }

        public final void setHyperParameters(RFTHyperParameters.BuilderImpl hyperParameters) {
            this.hyperParameters = hyperParameters != null ? hyperParameters.build() : null;
        }

        @Override
        public final Builder hyperParameters(RFTHyperParameters hyperParameters) {
            this.hyperParameters = hyperParameters;
            return this;
        }

        public RFTConfig build() {
            return new RFTConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RFTConfig> {
        public Builder graderConfig(GraderConfig var1);

        default public Builder graderConfig(Consumer<GraderConfig.Builder> graderConfig) {
            return this.graderConfig((GraderConfig)((GraderConfig.Builder)GraderConfig.builder().applyMutation(graderConfig)).build());
        }

        public Builder hyperParameters(RFTHyperParameters var1);

        default public Builder hyperParameters(Consumer<RFTHyperParameters.Builder> hyperParameters) {
            return this.hyperParameters((RFTHyperParameters)((RFTHyperParameters.Builder)RFTHyperParameters.builder().applyMutation(hyperParameters)).build());
        }
    }
}

