/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinition;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomatedReasoningPolicyRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateAutomatedReasoningPolicyRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateAutomatedReasoningPolicyRequest.getter(UpdateAutomatedReasoningPolicyRequest::policyArn)).setter(UpdateAutomatedReasoningPolicyRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyDefinition> POLICY_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policyDefinition").getter(UpdateAutomatedReasoningPolicyRequest.getter(UpdateAutomatedReasoningPolicyRequest::policyDefinition)).setter(UpdateAutomatedReasoningPolicyRequest.setter(Builder::policyDefinition)).constructor(AutomatedReasoningPolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinition").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAutomatedReasoningPolicyRequest.getter(UpdateAutomatedReasoningPolicyRequest::name)).setter(UpdateAutomatedReasoningPolicyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAutomatedReasoningPolicyRequest.getter(UpdateAutomatedReasoningPolicyRequest::description)).setter(UpdateAutomatedReasoningPolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, POLICY_DEFINITION_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomatedReasoningPolicyRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final AutomatedReasoningPolicyDefinition policyDefinition;
    private final String name;
    private final String description;

    private UpdateAutomatedReasoningPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyDefinition = builder.policyDefinition;
        this.name = builder.name;
        this.description = builder.description;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final AutomatedReasoningPolicyDefinition policyDefinition() {
        return this.policyDefinition;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyRequest)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyRequest other = (UpdateAutomatedReasoningPolicyRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDefinition(), other.policyDefinition()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomatedReasoningPolicyRequest").add("PolicyArn", (Object)this.policyArn()).add("PolicyDefinition", (Object)this.policyDefinition()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "policyDefinition": {
                return Optional.ofNullable(clazz.cast(this.policyDefinition()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("policyDefinition", POLICY_DEFINITION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private AutomatedReasoningPolicyDefinition policyDefinition;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.policyDefinition(model.policyDefinition);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AutomatedReasoningPolicyDefinition.Builder getPolicyDefinition() {
            return this.policyDefinition != null ? this.policyDefinition.toBuilder() : null;
        }

        public final void setPolicyDefinition(AutomatedReasoningPolicyDefinition.BuilderImpl policyDefinition) {
            this.policyDefinition = policyDefinition != null ? policyDefinition.build() : null;
        }

        @Override
        public final Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
            this.policyDefinition = policyDefinition;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyRequest build() {
            return new UpdateAutomatedReasoningPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyRequest> {
        public Builder policyArn(String var1);

        public Builder policyDefinition(AutomatedReasoningPolicyDefinition var1);

        default public Builder policyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
            return this.policyDefinition((AutomatedReasoningPolicyDefinition)((AutomatedReasoningPolicyDefinition.Builder)AutomatedReasoningPolicyDefinition.builder().applyMutation(policyDefinition)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

