/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.CustomModelSummary;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse;

public class ListCustomModelsPublisher
implements SdkPublisher<ListCustomModelsResponse> {
    private final BedrockAsyncClient client;
    private final ListCustomModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomModelsPublisher(BedrockAsyncClient client, ListCustomModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomModelsPublisher(BedrockAsyncClient client, ListCustomModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomModelSummary> modelSummaries() {
        return this.flatMapIterable(response -> response.modelSummaries());
    }

    private class ListCustomModelsResponseFetcher
    implements AsyncPageFetcher<ListCustomModelsResponse> {
        private ListCustomModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomModelsResponse> nextPage(ListCustomModelsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomModelsPublisher.this.client.listCustomModels(ListCustomModelsPublisher.this.firstRequest);
            }
            return ListCustomModelsPublisher.this.client.listCustomModels((ListCustomModelsRequest)((Object)ListCustomModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

