/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.GuardrailSummary;
import software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest;
import software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse;

public class ListGuardrailsPublisher
implements SdkPublisher<ListGuardrailsResponse> {
    private final BedrockAsyncClient client;
    private final ListGuardrailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGuardrailsPublisher(BedrockAsyncClient client, ListGuardrailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGuardrailsPublisher(BedrockAsyncClient client, ListGuardrailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGuardrailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGuardrailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GuardrailSummary> guardrails() {
        return this.flatMapIterable(response -> response.guardrails());
    }

    private class ListGuardrailsResponseFetcher
    implements AsyncPageFetcher<ListGuardrailsResponse> {
        private ListGuardrailsResponseFetcher() {
        }

        public boolean hasNextPage(ListGuardrailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGuardrailsResponse> nextPage(ListGuardrailsResponse previousPage) {
            if (previousPage == null) {
                return ListGuardrailsPublisher.this.client.listGuardrails(ListGuardrailsPublisher.this.firstRequest);
            }
            return ListGuardrailsPublisher.this.client.listGuardrails((ListGuardrailsRequest)((Object)ListGuardrailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

