/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ImportedModelSummary;
import software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse;

public class ListImportedModelsPublisher
implements SdkPublisher<ListImportedModelsResponse> {
    private final BedrockAsyncClient client;
    private final ListImportedModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportedModelsPublisher(BedrockAsyncClient client, ListImportedModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportedModelsPublisher(BedrockAsyncClient client, ListImportedModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportedModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportedModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportedModelSummary> modelSummaries() {
        return this.flatMapIterable(response -> response.modelSummaries());
    }

    private class ListImportedModelsResponseFetcher
    implements AsyncPageFetcher<ListImportedModelsResponse> {
        private ListImportedModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportedModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportedModelsResponse> nextPage(ListImportedModelsResponse previousPage) {
            if (previousPage == null) {
                return ListImportedModelsPublisher.this.client.listImportedModels(ListImportedModelsPublisher.this.firstRequest);
            }
            return ListImportedModelsPublisher.this.client.listImportedModels((ListImportedModelsRequest)((Object)ListImportedModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

