/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary;

public class ListModelCustomizationJobsPublisher
implements SdkPublisher<ListModelCustomizationJobsResponse> {
    private final BedrockAsyncClient client;
    private final ListModelCustomizationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelCustomizationJobsPublisher(BedrockAsyncClient client, ListModelCustomizationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelCustomizationJobsPublisher(BedrockAsyncClient client, ListModelCustomizationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelCustomizationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelCustomizationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelCustomizationJobSummary> modelCustomizationJobSummaries() {
        return this.flatMapIterable(response -> response.modelCustomizationJobSummaries());
    }

    private class ListModelCustomizationJobsResponseFetcher
    implements AsyncPageFetcher<ListModelCustomizationJobsResponse> {
        private ListModelCustomizationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCustomizationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelCustomizationJobsResponse> nextPage(ListModelCustomizationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCustomizationJobsPublisher.this.client.listModelCustomizationJobs(ListModelCustomizationJobsPublisher.this.firstRequest);
            }
            return ListModelCustomizationJobsPublisher.this.client.listModelCustomizationJobs((ListModelCustomizationJobsRequest)((Object)ListModelCustomizationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

