/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures a bedrock knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseConfiguration.Builder, KnowledgeBaseConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(KnowledgeBaseConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<VectorKnowledgeBaseConfiguration> VECTOR_KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField
            .<VectorKnowledgeBaseConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("vectorKnowledgeBaseConfiguration")
            .getter(getter(KnowledgeBaseConfiguration::vectorKnowledgeBaseConfiguration))
            .setter(setter(Builder::vectorKnowledgeBaseConfiguration))
            .constructor(VectorKnowledgeBaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorKnowledgeBaseConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            VECTOR_KNOWLEDGE_BASE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration;

    private KnowledgeBaseConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.vectorKnowledgeBaseConfiguration = builder.vectorKnowledgeBaseConfiguration;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see KnowledgeBaseType
     */
    public final KnowledgeBaseType type() {
        return KnowledgeBaseType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see KnowledgeBaseType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the VectorKnowledgeBaseConfiguration property for this object.
     * 
     * @return The value of the VectorKnowledgeBaseConfiguration property for this object.
     */
    public final VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration() {
        return vectorKnowledgeBaseConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vectorKnowledgeBaseConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseConfiguration)) {
            return false;
        }
        KnowledgeBaseConfiguration other = (KnowledgeBaseConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(vectorKnowledgeBaseConfiguration(), other.vectorKnowledgeBaseConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseConfiguration").add("Type", typeAsString())
                .add("VectorKnowledgeBaseConfiguration", vectorKnowledgeBaseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "vectorKnowledgeBaseConfiguration":
            return Optional.ofNullable(clazz.cast(vectorKnowledgeBaseConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseConfiguration> {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder type(KnowledgeBaseType type);

        /**
         * Sets the value of the VectorKnowledgeBaseConfiguration property for this object.
         *
         * @param vectorKnowledgeBaseConfiguration
         *        The new value for the VectorKnowledgeBaseConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration);

        /**
         * Sets the value of the VectorKnowledgeBaseConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VectorKnowledgeBaseConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorKnowledgeBaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorKnowledgeBaseConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration)}.
         * 
         * @param vectorKnowledgeBaseConfiguration
         *        a consumer that will call methods on {@link VectorKnowledgeBaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration)
         */
        default Builder vectorKnowledgeBaseConfiguration(
                Consumer<VectorKnowledgeBaseConfiguration.Builder> vectorKnowledgeBaseConfiguration) {
            return vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration.builder()
                    .applyMutation(vectorKnowledgeBaseConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseConfiguration model) {
            type(model.type);
            vectorKnowledgeBaseConfiguration(model.vectorKnowledgeBaseConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KnowledgeBaseType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final VectorKnowledgeBaseConfiguration.Builder getVectorKnowledgeBaseConfiguration() {
            return vectorKnowledgeBaseConfiguration != null ? vectorKnowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setVectorKnowledgeBaseConfiguration(
                VectorKnowledgeBaseConfiguration.BuilderImpl vectorKnowledgeBaseConfiguration) {
            this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration != null ? vectorKnowledgeBaseConfiguration
                    .build() : null;
        }

        @Override
        public final Builder vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration) {
            this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
            return this;
        }

        @Override
        public KnowledgeBaseConfiguration build() {
            return new KnowledgeBaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
