/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List Agent Aliases Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentAliasesResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<ListAgentAliasesResponse.Builder, ListAgentAliasesResponse> {
    private static final SdkField<List<AgentAliasSummary>> AGENT_ALIAS_SUMMARIES_FIELD = SdkField
            .<List<AgentAliasSummary>> builder(MarshallingType.LIST)
            .memberName("agentAliasSummaries")
            .getter(getter(ListAgentAliasesResponse::agentAliasSummaries))
            .setter(setter(Builder::agentAliasSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentAliasSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentAliasSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAgentAliasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AgentAliasSummary> agentAliasSummaries;

    private final String nextToken;

    private ListAgentAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.agentAliasSummaries = builder.agentAliasSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentAliasSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentAliasSummaries() {
        return agentAliasSummaries != null && !(agentAliasSummaries instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AgentAliasSummaries property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentAliasSummaries} method.
     * </p>
     * 
     * @return The value of the AgentAliasSummaries property for this object.
     */
    public final List<AgentAliasSummary> agentAliasSummaries() {
        return agentAliasSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentAliasSummaries() ? agentAliasSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentAliasesResponse)) {
            return false;
        }
        ListAgentAliasesResponse other = (ListAgentAliasesResponse) obj;
        return hasAgentAliasSummaries() == other.hasAgentAliasSummaries()
                && Objects.equals(agentAliasSummaries(), other.agentAliasSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgentAliasesResponse")
                .add("AgentAliasSummaries", hasAgentAliasSummaries() ? agentAliasSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasSummaries":
            return Optional.ofNullable(clazz.cast(agentAliasSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentAliasesResponse, T> g) {
        return obj -> g.apply((ListAgentAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgentAliasesResponse> {
        /**
         * Sets the value of the AgentAliasSummaries property for this object.
         *
         * @param agentAliasSummaries
         *        The new value for the AgentAliasSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasSummaries(Collection<AgentAliasSummary> agentAliasSummaries);

        /**
         * Sets the value of the AgentAliasSummaries property for this object.
         *
         * @param agentAliasSummaries
         *        The new value for the AgentAliasSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasSummaries(AgentAliasSummary... agentAliasSummaries);

        /**
         * Sets the value of the AgentAliasSummaries property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #agentAliasSummaries(List<AgentAliasSummary>)}.
         * 
         * @param agentAliasSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentAliasSummaries(java.util.Collection<AgentAliasSummary>)
         */
        Builder agentAliasSummaries(Consumer<AgentAliasSummary.Builder>... agentAliasSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private List<AgentAliasSummary> agentAliasSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentAliasesResponse model) {
            super(model);
            agentAliasSummaries(model.agentAliasSummaries);
            nextToken(model.nextToken);
        }

        public final List<AgentAliasSummary.Builder> getAgentAliasSummaries() {
            List<AgentAliasSummary.Builder> result = AgentAliasSummariesCopier.copyToBuilder(this.agentAliasSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentAliasSummaries(Collection<AgentAliasSummary.BuilderImpl> agentAliasSummaries) {
            this.agentAliasSummaries = AgentAliasSummariesCopier.copyFromBuilder(agentAliasSummaries);
        }

        @Override
        public final Builder agentAliasSummaries(Collection<AgentAliasSummary> agentAliasSummaries) {
            this.agentAliasSummaries = AgentAliasSummariesCopier.copy(agentAliasSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentAliasSummaries(AgentAliasSummary... agentAliasSummaries) {
            agentAliasSummaries(Arrays.asList(agentAliasSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentAliasSummaries(Consumer<AgentAliasSummary.Builder>... agentAliasSummaries) {
            agentAliasSummaries(Stream.of(agentAliasSummaries).map(c -> AgentAliasSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentAliasesResponse build() {
            return new ListAgentAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
