/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIngestionJobsRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<ListIngestionJobsRequest.Builder, ListIngestionJobsRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ListIngestionJobsRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(ListIngestionJobsRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<List<IngestionJobFilter>> FILTERS_FIELD = SdkField
            .<List<IngestionJobFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListIngestionJobsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IngestionJobFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IngestionJobFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IngestionJobSortBy> SORT_BY_FIELD = SdkField
            .<IngestionJobSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(ListIngestionJobsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(IngestionJobSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListIngestionJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIngestionJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            DATA_SOURCE_ID_FIELD, FILTERS_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String knowledgeBaseId;

    private final String dataSourceId;

    private final List<IngestionJobFilter> filters;

    private final IngestionJobSortBy sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListIngestionJobsRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the KnowledgeBaseId property for this object.
     * 
     * @return The value of the KnowledgeBaseId property for this object.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * Returns the value of the DataSourceId property for this object.
     * 
     * @return The value of the DataSourceId property for this object.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Filters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The value of the Filters property for this object.
     */
    public final List<IngestionJobFilter> filters() {
        return filters;
    }

    /**
     * Returns the value of the SortBy property for this object.
     * 
     * @return The value of the SortBy property for this object.
     */
    public final IngestionJobSortBy sortBy() {
        return sortBy;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionJobsRequest)) {
            return false;
        }
        ListIngestionJobsRequest other = (ListIngestionJobsRequest) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(sortBy(), other.sortBy()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIngestionJobsRequest").add("KnowledgeBaseId", knowledgeBaseId())
                .add("DataSourceId", dataSourceId()).add("Filters", hasFilters() ? filters() : null).add("SortBy", sortBy())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionJobsRequest, T> g) {
        return obj -> g.apply((ListIngestionJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListIngestionJobsRequest> {
        /**
         * Sets the value of the KnowledgeBaseId property for this object.
         *
         * @param knowledgeBaseId
         *        The new value for the KnowledgeBaseId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * Sets the value of the DataSourceId property for this object.
         *
         * @param dataSourceId
         *        The new value for the DataSourceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * Sets the value of the Filters property for this object.
         *
         * @param filters
         *        The new value for the Filters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IngestionJobFilter> filters);

        /**
         * Sets the value of the Filters property for this object.
         *
         * @param filters
         *        The new value for the Filters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IngestionJobFilter... filters);

        /**
         * Sets the value of the Filters property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<IngestionJobFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<IngestionJobFilter>)
         */
        Builder filters(Consumer<IngestionJobFilter.Builder>... filters);

        /**
         * Sets the value of the SortBy property for this object.
         *
         * @param sortBy
         *        The new value for the SortBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(IngestionJobSortBy sortBy);

        /**
         * Sets the value of the SortBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IngestionJobSortBy.Builder} avoiding the
         * need to create one manually via {@link IngestionJobSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionJobSortBy.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(IngestionJobSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link IngestionJobSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(IngestionJobSortBy)
         */
        default Builder sortBy(Consumer<IngestionJobSortBy.Builder> sortBy) {
            return sortBy(IngestionJobSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String dataSourceId;

        private List<IngestionJobFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private IngestionJobSortBy sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionJobsRequest model) {
            super(model);
            knowledgeBaseId(model.knowledgeBaseId);
            dataSourceId(model.dataSourceId);
            filters(model.filters);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final List<IngestionJobFilter.Builder> getFilters() {
            List<IngestionJobFilter.Builder> result = IngestionJobFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IngestionJobFilter.BuilderImpl> filters) {
            this.filters = IngestionJobFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IngestionJobFilter> filters) {
            this.filters = IngestionJobFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IngestionJobFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IngestionJobFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IngestionJobFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final IngestionJobSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(IngestionJobSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(IngestionJobSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIngestionJobsRequest build() {
            return new ListIngestionJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
