/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.APISchema;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupExecutor;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupSignature;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentActionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentActionGroup> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AgentActionGroup.getter(AgentActionGroup::agentId)).setter(AgentActionGroup.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(AgentActionGroup.getter(AgentActionGroup::agentVersion)).setter(AgentActionGroup.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final SdkField<String> ACTION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupId").getter(AgentActionGroup.getter(AgentActionGroup::actionGroupId)).setter(AgentActionGroup.setter(Builder::actionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupId").build()}).build();
    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupName").getter(AgentActionGroup.getter(AgentActionGroup::actionGroupName)).setter(AgentActionGroup.setter(Builder::actionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AgentActionGroup.getter(AgentActionGroup::clientToken)).setter(AgentActionGroup.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentActionGroup.getter(AgentActionGroup::description)).setter(AgentActionGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AgentActionGroup.getter(AgentActionGroup::createdAt)).setter(AgentActionGroup.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AgentActionGroup.getter(AgentActionGroup::updatedAt)).setter(AgentActionGroup.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PARENT_ACTION_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentActionSignature").getter(AgentActionGroup.getter(AgentActionGroup::parentActionSignatureAsString)).setter(AgentActionGroup.setter(Builder::parentActionSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionSignature").build()}).build();
    private static final SdkField<ActionGroupExecutor> ACTION_GROUP_EXECUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionGroupExecutor").getter(AgentActionGroup.getter(AgentActionGroup::actionGroupExecutor)).setter(AgentActionGroup.setter(Builder::actionGroupExecutor)).constructor(ActionGroupExecutor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupExecutor").build()}).build();
    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiSchema").getter(AgentActionGroup.getter(AgentActionGroup::apiSchema)).setter(AgentActionGroup.setter(Builder::apiSchema)).constructor(APISchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()}).build();
    private static final SdkField<String> ACTION_GROUP_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupState").getter(AgentActionGroup.getter(AgentActionGroup::actionGroupStateAsString)).setter(AgentActionGroup.setter(Builder::actionGroupState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_VERSION_FIELD, ACTION_GROUP_ID_FIELD, ACTION_GROUP_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, PARENT_ACTION_SIGNATURE_FIELD, ACTION_GROUP_EXECUTOR_FIELD, API_SCHEMA_FIELD, ACTION_GROUP_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentId;
    private final String agentVersion;
    private final String actionGroupId;
    private final String actionGroupName;
    private final String clientToken;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String parentActionSignature;
    private final ActionGroupExecutor actionGroupExecutor;
    private final APISchema apiSchema;
    private final String actionGroupState;

    private AgentActionGroup(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.actionGroupId = builder.actionGroupId;
        this.actionGroupName = builder.actionGroupName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.parentActionSignature = builder.parentActionSignature;
        this.actionGroupExecutor = builder.actionGroupExecutor;
        this.apiSchema = builder.apiSchema;
        this.actionGroupState = builder.actionGroupState;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String actionGroupId() {
        return this.actionGroupId;
    }

    public final String actionGroupName() {
        return this.actionGroupName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final ActionGroupSignature parentActionSignature() {
        return ActionGroupSignature.fromValue(this.parentActionSignature);
    }

    public final String parentActionSignatureAsString() {
        return this.parentActionSignature;
    }

    public final ActionGroupExecutor actionGroupExecutor() {
        return this.actionGroupExecutor;
    }

    public final APISchema apiSchema() {
        return this.apiSchema;
    }

    public final ActionGroupState actionGroupState() {
        return ActionGroupState.fromValue(this.actionGroupState);
    }

    public final String actionGroupStateAsString() {
        return this.actionGroupState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentActionSignatureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupExecutor());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentActionGroup)) {
            return false;
        }
        AgentActionGroup other = (AgentActionGroup)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.actionGroupId(), other.actionGroupId()) && Objects.equals(this.actionGroupName(), other.actionGroupName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.parentActionSignatureAsString(), other.parentActionSignatureAsString()) && Objects.equals(this.actionGroupExecutor(), other.actionGroupExecutor()) && Objects.equals(this.apiSchema(), other.apiSchema()) && Objects.equals(this.actionGroupStateAsString(), other.actionGroupStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AgentActionGroup").add("AgentId", (Object)this.agentId()).add("AgentVersion", (Object)this.agentVersion()).add("ActionGroupId", (Object)this.actionGroupId()).add("ActionGroupName", (Object)this.actionGroupName()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ParentActionSignature", (Object)this.parentActionSignatureAsString()).add("ActionGroupExecutor", (Object)this.actionGroupExecutor()).add("ApiSchema", (Object)this.apiSchema()).add("ActionGroupState", (Object)this.actionGroupStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "actionGroupId": {
                return Optional.ofNullable(clazz.cast(this.actionGroupId()));
            }
            case "actionGroupName": {
                return Optional.ofNullable(clazz.cast(this.actionGroupName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "parentActionSignature": {
                return Optional.ofNullable(clazz.cast(this.parentActionSignatureAsString()));
            }
            case "actionGroupExecutor": {
                return Optional.ofNullable(clazz.cast(this.actionGroupExecutor()));
            }
            case "apiSchema": {
                return Optional.ofNullable(clazz.cast(this.apiSchema()));
            }
            case "actionGroupState": {
                return Optional.ofNullable(clazz.cast(this.actionGroupStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentActionGroup, T> g) {
        return obj -> g.apply((AgentActionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private String agentVersion;
        private String actionGroupId;
        private String actionGroupName;
        private String clientToken;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String parentActionSignature;
        private ActionGroupExecutor actionGroupExecutor;
        private APISchema apiSchema;
        private String actionGroupState;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentActionGroup model) {
            this.agentId(model.agentId);
            this.agentVersion(model.agentVersion);
            this.actionGroupId(model.actionGroupId);
            this.actionGroupName(model.actionGroupName);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.parentActionSignature(model.parentActionSignature);
            this.actionGroupExecutor(model.actionGroupExecutor);
            this.apiSchema(model.apiSchema);
            this.actionGroupState(model.actionGroupState);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getActionGroupId() {
            return this.actionGroupId;
        }

        public final void setActionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
        }

        @Override
        public final Builder actionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
            return this;
        }

        public final String getActionGroupName() {
            return this.actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getParentActionSignature() {
            return this.parentActionSignature;
        }

        public final void setParentActionSignature(String parentActionSignature) {
            this.parentActionSignature = parentActionSignature;
        }

        @Override
        public final Builder parentActionSignature(String parentActionSignature) {
            this.parentActionSignature = parentActionSignature;
            return this;
        }

        @Override
        public final Builder parentActionSignature(ActionGroupSignature parentActionSignature) {
            this.parentActionSignature(parentActionSignature == null ? null : parentActionSignature.toString());
            return this;
        }

        public final ActionGroupExecutor.Builder getActionGroupExecutor() {
            return this.actionGroupExecutor != null ? this.actionGroupExecutor.toBuilder() : null;
        }

        public final void setActionGroupExecutor(ActionGroupExecutor.BuilderImpl actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor != null ? actionGroupExecutor.build() : null;
        }

        @Override
        public final Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor;
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return this.apiSchema != null ? this.apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public final String getActionGroupState() {
            return this.actionGroupState;
        }

        public final void setActionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
        }

        @Override
        public final Builder actionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
            return this;
        }

        @Override
        public final Builder actionGroupState(ActionGroupState actionGroupState) {
            this.actionGroupState(actionGroupState == null ? null : actionGroupState.toString());
            return this;
        }

        public AgentActionGroup build() {
            return new AgentActionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentActionGroup> {
        public Builder agentId(String var1);

        public Builder agentVersion(String var1);

        public Builder actionGroupId(String var1);

        public Builder actionGroupName(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder parentActionSignature(String var1);

        public Builder parentActionSignature(ActionGroupSignature var1);

        public Builder actionGroupExecutor(ActionGroupExecutor var1);

        default public Builder actionGroupExecutor(Consumer<ActionGroupExecutor.Builder> actionGroupExecutor) {
            return this.actionGroupExecutor((ActionGroupExecutor)((ActionGroupExecutor.Builder)ActionGroupExecutor.builder().applyMutation(actionGroupExecutor)).build());
        }

        public Builder apiSchema(APISchema var1);

        default public Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return this.apiSchema((APISchema)((APISchema.Builder)APISchema.builder().applyMutation(apiSchema)).build());
        }

        public Builder actionGroupState(String var1);

        public Builder actionGroupState(ActionGroupState var1);
    }
}

