/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a connection originating from a node that isn't a Condition node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowDataConnectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowDataConnectionConfiguration.Builder, FlowDataConnectionConfiguration> {
    private static final SdkField<String> SOURCE_OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceOutput").getter(getter(FlowDataConnectionConfiguration::sourceOutput))
            .setter(setter(Builder::sourceOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceOutput").build()).build();

    private static final SdkField<String> TARGET_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetInput").getter(getter(FlowDataConnectionConfiguration::targetInput))
            .setter(setter(Builder::targetInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_OUTPUT_FIELD,
            TARGET_INPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceOutput;

    private final String targetInput;

    private FlowDataConnectionConfiguration(BuilderImpl builder) {
        this.sourceOutput = builder.sourceOutput;
        this.targetInput = builder.targetInput;
    }

    /**
     * <p>
     * The name of the output in the source node that the connection begins from.
     * </p>
     * 
     * @return The name of the output in the source node that the connection begins from.
     */
    public final String sourceOutput() {
        return sourceOutput;
    }

    /**
     * <p>
     * The name of the input in the target node that the connection ends at.
     * </p>
     * 
     * @return The name of the input in the target node that the connection ends at.
     */
    public final String targetInput() {
        return targetInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceOutput());
        hashCode = 31 * hashCode + Objects.hashCode(targetInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDataConnectionConfiguration)) {
            return false;
        }
        FlowDataConnectionConfiguration other = (FlowDataConnectionConfiguration) obj;
        return Objects.equals(sourceOutput(), other.sourceOutput()) && Objects.equals(targetInput(), other.targetInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowDataConnectionConfiguration").add("SourceOutput", sourceOutput())
                .add("TargetInput", targetInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceOutput":
            return Optional.ofNullable(clazz.cast(sourceOutput()));
        case "targetInput":
            return Optional.ofNullable(clazz.cast(targetInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDataConnectionConfiguration, T> g) {
        return obj -> g.apply((FlowDataConnectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowDataConnectionConfiguration> {
        /**
         * <p>
         * The name of the output in the source node that the connection begins from.
         * </p>
         * 
         * @param sourceOutput
         *        The name of the output in the source node that the connection begins from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceOutput(String sourceOutput);

        /**
         * <p>
         * The name of the input in the target node that the connection ends at.
         * </p>
         * 
         * @param targetInput
         *        The name of the input in the target node that the connection ends at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInput(String targetInput);
    }

    static final class BuilderImpl implements Builder {
        private String sourceOutput;

        private String targetInput;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDataConnectionConfiguration model) {
            sourceOutput(model.sourceOutput);
            targetInput(model.targetInput);
        }

        public final String getSourceOutput() {
            return sourceOutput;
        }

        public final void setSourceOutput(String sourceOutput) {
            this.sourceOutput = sourceOutput;
        }

        @Override
        public final Builder sourceOutput(String sourceOutput) {
            this.sourceOutput = sourceOutput;
            return this;
        }

        public final String getTargetInput() {
            return targetInput;
        }

        public final void setTargetInput(String targetInput) {
            this.targetInput = targetInput;
        }

        @Override
        public final Builder targetInput(String targetInput) {
            this.targetInput = targetInput;
            return this;
        }

        @Override
        public FlowDataConnectionConfiguration build() {
            return new FlowDataConnectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
