/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the definition of a flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowSummary implements SdkPojo, Serializable, ToCopyableBuilder<FlowSummary.Builder, FlowSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(FlowSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(FlowSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(FlowSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FlowSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FlowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FlowSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(FlowSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(FlowSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String id;

    private final String name;

    private final String status;

    private final Instant updatedAt;

    private final String version;

    private FlowSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.version = builder.version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the flow was created.
     * </p>
     * 
     * @return The time at which the flow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the flow.
     * </p>
     * 
     * @return A description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the flow.
     * </p>
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the flow. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you
     * can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes for
     * testing. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request
     * to package the latest changes into the <code>DRAFT</code> version.
     * </p>
     * </li>
     * <li>
     * <p>
     * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
     * testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – The last API operation that you invoked on the flow failed. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
     * check the error message in the <code>validations</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
     *         flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest
     *         changes for testing. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
     *         request to package the latest changes into the <code>DRAFT</code> version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes
     *         for testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
     *         testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – The last API operation that you invoked on the flow failed. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request
     *         and check the error message in the <code>validations</code> field.
     *         </p>
     *         </li>
     * @see FlowStatus
     */
    public final FlowStatus status() {
        return FlowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the flow. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you
     * can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes for
     * testing. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request
     * to package the latest changes into the <code>DRAFT</code> version.
     * </p>
     * </li>
     * <li>
     * <p>
     * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
     * testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – The last API operation that you invoked on the flow failed. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
     * check the error message in the <code>validations</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
     *         flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest
     *         changes for testing. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
     *         request to package the latest changes into the <code>DRAFT</code> version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes
     *         for testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
     *         testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – The last API operation that you invoked on the flow failed. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request
     *         and check the error message in the <code>validations</code> field.
     *         </p>
     *         </li>
     * @see FlowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the flow was last updated.
     * </p>
     * 
     * @return The time at which the flow was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The latest version of the flow.
     * </p>
     * 
     * @return The latest version of the flow.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowSummary)) {
            return false;
        }
        FlowSummary other = (FlowSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowSummary").add("Arn", arn()).add("CreatedAt", createdAt()).add("Description", description())
                .add("Id", id()).add("Name", name()).add("Status", statusAsString()).add("UpdatedAt", updatedAt())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowSummary, T> g) {
        return obj -> g.apply((FlowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the flow was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the flow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the flow.
         * </p>
         * 
         * @param description
         *        A description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param id
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the flow.
         * </p>
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the flow. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow,
         * you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes
         * for testing. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
         * request to package the latest changes into the <code>DRAFT</code> version.
         * </p>
         * </li>
         * <li>
         * <p>
         * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
         * testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – The last API operation that you invoked on the flow failed. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
         * check the error message in the <code>validations</code> field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the flow. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
         *        flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the
         *        latest changes for testing. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html"
         *        >PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest
         *        changes for testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
         *        testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – The last API operation that you invoked on the flow failed. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a>
         *        request and check the error message in the <code>validations</code> field.
         *        </p>
         *        </li>
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the flow. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow,
         * you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes
         * for testing. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
         * request to package the latest changes into the <code>DRAFT</code> version.
         * </p>
         * </li>
         * <li>
         * <p>
         * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
         * testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – The last API operation that you invoked on the flow failed. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
         * check the error message in the <code>validations</code> field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the flow. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
         *        flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the
         *        latest changes for testing. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html"
         *        >PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest
         *        changes for testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
         *        testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – The last API operation that you invoked on the flow failed. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a>
         *        request and check the error message in the <code>validations</code> field.
         *        </p>
         *        </li>
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder status(FlowStatus status);

        /**
         * <p>
         * The time at which the flow was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the flow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The latest version of the flow.
         * </p>
         * 
         * @param version
         *        The latest version of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String id;

        private String name;

        private String status;

        private Instant updatedAt;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            name(model.name);
            status(model.status);
            updatedAt(model.updatedAt);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public FlowSummary build() {
            return new FlowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
