/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFlowAliasRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<GetFlowAliasRequest.Builder, GetFlowAliasRequest> {
    private static final SdkField<String> ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aliasIdentifier").getter(getter(GetFlowAliasRequest::aliasIdentifier))
            .setter(setter(Builder::aliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aliasIdentifier").build()).build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(GetFlowAliasRequest::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_IDENTIFIER_FIELD,
            FLOW_IDENTIFIER_FIELD));

    private final String aliasIdentifier;

    private final String flowIdentifier;

    private GetFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasIdentifier = builder.aliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the alias for which to retrieve information.
     * </p>
     * 
     * @return The unique identifier of the alias for which to retrieve information.
     */
    public final String aliasIdentifier() {
        return aliasIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow that the alias belongs to.
     * </p>
     * 
     * @return The unique identifier of the flow that the alias belongs to.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowAliasRequest)) {
            return false;
        }
        GetFlowAliasRequest other = (GetFlowAliasRequest) obj;
        return Objects.equals(aliasIdentifier(), other.aliasIdentifier())
                && Objects.equals(flowIdentifier(), other.flowIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFlowAliasRequest").add("AliasIdentifier", aliasIdentifier())
                .add("FlowIdentifier", flowIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aliasIdentifier":
            return Optional.ofNullable(clazz.cast(aliasIdentifier()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFlowAliasRequest, T> g) {
        return obj -> g.apply((GetFlowAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFlowAliasRequest> {
        /**
         * <p>
         * The unique identifier of the alias for which to retrieve information.
         * </p>
         * 
         * @param aliasIdentifier
         *        The unique identifier of the alias for which to retrieve information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasIdentifier(String aliasIdentifier);

        /**
         * <p>
         * The unique identifier of the flow that the alias belongs to.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow that the alias belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String aliasIdentifier;

        private String flowIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowAliasRequest model) {
            super(model);
            aliasIdentifier(model.aliasIdentifier);
            flowIdentifier(model.flowIdentifier);
        }

        public final String getAliasIdentifier() {
            return aliasIdentifier;
        }

        public final void setAliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
        }

        @Override
        public final Builder aliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFlowAliasRequest build() {
            return new GetFlowAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
