/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFlowResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<GetFlowResponse.Builder, GetFlowResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetFlowResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetFlowResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(GetFlowResponse::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<FlowDefinition> DEFINITION_FIELD = SdkField.<FlowDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("definition").getter(getter(GetFlowResponse::definition)).setter(setter(Builder::definition))
            .constructor(FlowDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetFlowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(GetFlowResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetFlowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetFlowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetFlowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetFlowResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<FlowValidation>> VALIDATIONS_FIELD = SdkField
            .<List<FlowValidation>> builder(MarshallingType.LIST)
            .memberName("validations")
            .getter(getter(GetFlowResponse::validations))
            .setter(setter(Builder::validations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowValidation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowValidation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(GetFlowResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_ARN_FIELD, ID_FIELD,
            NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, VALIDATIONS_FIELD, VERSION_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final String customerEncryptionKeyArn;

    private final FlowDefinition definition;

    private final String description;

    private final String executionRoleArn;

    private final String id;

    private final String name;

    private final String status;

    private final Instant updatedAt;

    private final List<FlowValidation> validations;

    private final String version;

    private GetFlowResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.definition = builder.definition;
        this.description = builder.description;
        this.executionRoleArn = builder.executionRoleArn;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.validations = builder.validations;
        this.version = builder.version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the flow was created.
     * </p>
     * 
     * @return The time at which the flow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * The definition of the nodes and connections between the nodes in the flow.
     * </p>
     * 
     * @return The definition of the nodes and connections between the nodes in the flow.
     */
    public final FlowDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The description of the flow.
     * </p>
     * 
     * @return The description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row for
     * flows</a> in the Amazon Bedrock User Guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row
     *         for flows</a> in the Amazon Bedrock User Guide.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the flow.
     * </p>
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the flow. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you
     * can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes for
     * testing. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request
     * to package the latest changes into the <code>DRAFT</code> version.
     * </p>
     * </li>
     * <li>
     * <p>
     * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
     * testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – The last API operation that you invoked on the flow failed. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
     * check the error message in the <code>validations</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
     *         flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest
     *         changes for testing. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
     *         request to package the latest changes into the <code>DRAFT</code> version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes
     *         for testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
     *         testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – The last API operation that you invoked on the flow failed. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request
     *         and check the error message in the <code>validations</code> field.
     *         </p>
     *         </li>
     * @see FlowStatus
     */
    public final FlowStatus status() {
        return FlowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the flow. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you
     * can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes for
     * testing. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request
     * to package the latest changes into the <code>DRAFT</code> version.
     * </p>
     * </li>
     * <li>
     * <p>
     * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
     * testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – The last API operation that you invoked on the flow failed. Send a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
     * check the error message in the <code>validations</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
     *         flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest
     *         changes for testing. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
     *         request to package the latest changes into the <code>DRAFT</code> version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes
     *         for testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
     *         testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – The last API operation that you invoked on the flow failed. Send a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request
     *         and check the error message in the <code>validations</code> field.
     *         </p>
     *         </li>
     * @see FlowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the flow was last updated.
     * </p>
     * 
     * @return The time at which the flow was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Validations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidations() {
        return validations != null && !(validations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of validation error messages related to the last failed operation on the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidations} method.
     * </p>
     * 
     * @return A list of validation error messages related to the last failed operation on the flow.
     */
    public final List<FlowValidation> validations() {
        return validations;
    }

    /**
     * <p>
     * The version of the flow for which information was retrieved.
     * </p>
     * 
     * @return The version of the flow for which information was retrieved.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidations() ? validations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowResponse)) {
            return false;
        }
        GetFlowResponse other = (GetFlowResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(definition(), other.definition()) && Objects.equals(description(), other.description())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasValidations() == other.hasValidations()
                && Objects.equals(validations(), other.validations()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFlowResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn()).add("Definition", definition())
                .add("Description", description()).add("ExecutionRoleArn", executionRoleArn()).add("Id", id())
                .add("Name", name()).add("Status", statusAsString()).add("UpdatedAt", updatedAt())
                .add("Validations", hasValidations() ? validations() : null).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "validations":
            return Optional.ofNullable(clazz.cast(validations()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFlowResponse, T> g) {
        return obj -> g.apply((GetFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFlowResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the flow was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the flow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * The definition of the nodes and connections between the nodes in the flow.
         * </p>
         * 
         * @param definition
         *        The definition of the nodes and connections between the nodes in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(FlowDefinition definition);

        /**
         * <p>
         * The definition of the nodes and connections between the nodes in the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowDefinition.Builder} avoiding the need
         * to create one manually via {@link FlowDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(FlowDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link FlowDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(FlowDefinition)
         */
        default Builder definition(Consumer<FlowDefinition.Builder> definition) {
            return definition(FlowDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The description of the flow.
         * </p>
         * 
         * @param description
         *        The description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service
         * row for flows</a> in the Amazon Bedrock User Guide.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service
         *        row for flows</a> in the Amazon Bedrock User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param id
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the flow.
         * </p>
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the flow. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow,
         * you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes
         * for testing. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
         * request to package the latest changes into the <code>DRAFT</code> version.
         * </p>
         * </li>
         * <li>
         * <p>
         * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
         * testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – The last API operation that you invoked on the flow failed. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
         * check the error message in the <code>validations</code> field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the flow. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
         *        flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the
         *        latest changes for testing. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html"
         *        >PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest
         *        changes for testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
         *        testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – The last API operation that you invoked on the flow failed. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a>
         *        request and check the error message in the <code>validations</code> field.
         *        </p>
         *        </li>
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the flow. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow,
         * you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes
         * for testing. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a>
         * request to package the latest changes into the <code>DRAFT</code> version.
         * </p>
         * </li>
         * <li>
         * <p>
         * Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for
         * testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – The last API operation that you invoked on the flow failed. Send a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and
         * check the error message in the <code>validations</code> field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the flow. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the
         *        flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the
         *        latest changes for testing. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html"
         *        >PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest
         *        changes for testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for
         *        testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – The last API operation that you invoked on the flow failed. Send a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a>
         *        request and check the error message in the <code>validations</code> field.
         *        </p>
         *        </li>
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder status(FlowStatus status);

        /**
         * <p>
         * The time at which the flow was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the flow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A list of validation error messages related to the last failed operation on the flow.
         * </p>
         * 
         * @param validations
         *        A list of validation error messages related to the last failed operation on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validations(Collection<FlowValidation> validations);

        /**
         * <p>
         * A list of validation error messages related to the last failed operation on the flow.
         * </p>
         * 
         * @param validations
         *        A list of validation error messages related to the last failed operation on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validations(FlowValidation... validations);

        /**
         * <p>
         * A list of validation error messages related to the last failed operation on the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowValidation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.FlowValidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowValidation.Builder#build()} is called
         * immediately and its result is passed to {@link #validations(List<FlowValidation>)}.
         * 
         * @param validations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowValidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validations(java.util.Collection<FlowValidation>)
         */
        Builder validations(Consumer<FlowValidation.Builder>... validations);

        /**
         * <p>
         * The version of the flow for which information was retrieved.
         * </p>
         * 
         * @param version
         *        The version of the flow for which information was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String customerEncryptionKeyArn;

        private FlowDefinition definition;

        private String description;

        private String executionRoleArn;

        private String id;

        private String name;

        private String status;

        private Instant updatedAt;

        private List<FlowValidation> validations = DefaultSdkAutoConstructList.getInstance();

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            definition(model.definition);
            description(model.description);
            executionRoleArn(model.executionRoleArn);
            id(model.id);
            name(model.name);
            status(model.status);
            updatedAt(model.updatedAt);
            validations(model.validations);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final FlowDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(FlowDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(FlowDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<FlowValidation.Builder> getValidations() {
            List<FlowValidation.Builder> result = FlowValidationsCopier.copyToBuilder(this.validations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidations(Collection<FlowValidation.BuilderImpl> validations) {
            this.validations = FlowValidationsCopier.copyFromBuilder(validations);
        }

        @Override
        public final Builder validations(Collection<FlowValidation> validations) {
            this.validations = FlowValidationsCopier.copy(validations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(FlowValidation... validations) {
            validations(Arrays.asList(validations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(Consumer<FlowValidation.Builder>... validations) {
            validations(Stream.of(validations).map(c -> FlowValidation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public GetFlowResponse build() {
            return new GetFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
