/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a prompt and whether it is from Prompt management or defined inline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptFlowNodeSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptFlowNodeSourceConfiguration.Builder, PromptFlowNodeSourceConfiguration> {
    private static final SdkField<PromptFlowNodeInlineConfiguration> INLINE_FIELD = SdkField
            .<PromptFlowNodeInlineConfiguration> builder(MarshallingType.SDK_POJO).memberName("inline")
            .getter(getter(PromptFlowNodeSourceConfiguration::inline)).setter(setter(Builder::inline))
            .constructor(PromptFlowNodeInlineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inline").build()).build();

    private static final SdkField<PromptFlowNodeResourceConfiguration> RESOURCE_FIELD = SdkField
            .<PromptFlowNodeResourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(PromptFlowNodeSourceConfiguration::resource)).setter(setter(Builder::resource))
            .constructor(PromptFlowNodeResourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_FIELD, RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PromptFlowNodeInlineConfiguration inline;

    private final PromptFlowNodeResourceConfiguration resource;

    private final Type type;

    private PromptFlowNodeSourceConfiguration(BuilderImpl builder) {
        this.inline = builder.inline;
        this.resource = builder.resource;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configurations for a prompt that is defined inline
     * </p>
     * 
     * @return Contains configurations for a prompt that is defined inline
     */
    public final PromptFlowNodeInlineConfiguration inline() {
        return inline;
    }

    /**
     * <p>
     * Contains configurations for a prompt from Prompt management.
     * </p>
     * 
     * @return Contains configurations for a prompt from Prompt management.
     */
    public final PromptFlowNodeResourceConfiguration resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inline());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptFlowNodeSourceConfiguration)) {
            return false;
        }
        PromptFlowNodeSourceConfiguration other = (PromptFlowNodeSourceConfiguration) obj;
        return Objects.equals(inline(), other.inline()) && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptFlowNodeSourceConfiguration").add("Inline", inline()).add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inline":
            return Optional.ofNullable(clazz.cast(inline()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #inline()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a prompt that is defined inline
     * </p>
     * 
     * @param inline
     *        Contains configurations for a prompt that is defined inline
     */
    public static PromptFlowNodeSourceConfiguration fromInline(PromptFlowNodeInlineConfiguration inline) {
        return builder().inline(inline).build();
    }

    /**
     * Create an instance of this class with {@link #inline()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a prompt that is defined inline
     * </p>
     * 
     * @param inline
     *        Contains configurations for a prompt that is defined inline
     */
    public static PromptFlowNodeSourceConfiguration fromInline(Consumer<PromptFlowNodeInlineConfiguration.Builder> inline) {
        PromptFlowNodeInlineConfiguration.Builder builder = PromptFlowNodeInlineConfiguration.builder();
        inline.accept(builder);
        return fromInline(builder.build());
    }

    /**
     * Create an instance of this class with {@link #resource()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a prompt from Prompt management.
     * </p>
     * 
     * @param resource
     *        Contains configurations for a prompt from Prompt management.
     */
    public static PromptFlowNodeSourceConfiguration fromResource(PromptFlowNodeResourceConfiguration resource) {
        return builder().resource(resource).build();
    }

    /**
     * Create an instance of this class with {@link #resource()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a prompt from Prompt management.
     * </p>
     * 
     * @param resource
     *        Contains configurations for a prompt from Prompt management.
     */
    public static PromptFlowNodeSourceConfiguration fromResource(Consumer<PromptFlowNodeResourceConfiguration.Builder> resource) {
        PromptFlowNodeResourceConfiguration.Builder builder = PromptFlowNodeResourceConfiguration.builder();
        resource.accept(builder);
        return fromResource(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptFlowNodeSourceConfiguration, T> g) {
        return obj -> g.apply((PromptFlowNodeSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptFlowNodeSourceConfiguration> {
        /**
         * <p>
         * Contains configurations for a prompt that is defined inline
         * </p>
         * 
         * @param inline
         *        Contains configurations for a prompt that is defined inline
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inline(PromptFlowNodeInlineConfiguration inline);

        /**
         * <p>
         * Contains configurations for a prompt that is defined inline
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PromptFlowNodeInlineConfiguration.Builder} avoiding the need to create one manually via
         * {@link PromptFlowNodeInlineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptFlowNodeInlineConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inline(PromptFlowNodeInlineConfiguration)}.
         * 
         * @param inline
         *        a consumer that will call methods on {@link PromptFlowNodeInlineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inline(PromptFlowNodeInlineConfiguration)
         */
        default Builder inline(Consumer<PromptFlowNodeInlineConfiguration.Builder> inline) {
            return inline(PromptFlowNodeInlineConfiguration.builder().applyMutation(inline).build());
        }

        /**
         * <p>
         * Contains configurations for a prompt from Prompt management.
         * </p>
         * 
         * @param resource
         *        Contains configurations for a prompt from Prompt management.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(PromptFlowNodeResourceConfiguration resource);

        /**
         * <p>
         * Contains configurations for a prompt from Prompt management.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PromptFlowNodeResourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link PromptFlowNodeResourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptFlowNodeResourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #resource(PromptFlowNodeResourceConfiguration)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link PromptFlowNodeResourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(PromptFlowNodeResourceConfiguration)
         */
        default Builder resource(Consumer<PromptFlowNodeResourceConfiguration.Builder> resource) {
            return resource(PromptFlowNodeResourceConfiguration.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PromptFlowNodeInlineConfiguration inline;

        private PromptFlowNodeResourceConfiguration resource;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PromptFlowNodeSourceConfiguration model) {
            inline(model.inline);
            resource(model.resource);
        }

        public final PromptFlowNodeInlineConfiguration.Builder getInline() {
            return inline != null ? inline.toBuilder() : null;
        }

        public final void setInline(PromptFlowNodeInlineConfiguration.BuilderImpl inline) {
            Object oldValue = this.inline;
            this.inline = inline != null ? inline.build() : null;
            handleUnionValueChange(Type.INLINE, oldValue, this.inline);
        }

        @Override
        public final Builder inline(PromptFlowNodeInlineConfiguration inline) {
            Object oldValue = this.inline;
            this.inline = inline;
            handleUnionValueChange(Type.INLINE, oldValue, this.inline);
            return this;
        }

        public final PromptFlowNodeResourceConfiguration.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(PromptFlowNodeResourceConfiguration.BuilderImpl resource) {
            Object oldValue = this.resource;
            this.resource = resource != null ? resource.build() : null;
            handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
        }

        @Override
        public final Builder resource(PromptFlowNodeResourceConfiguration resource) {
            Object oldValue = this.resource;
            this.resource = resource;
            handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
            return this;
        }

        @Override
        public PromptFlowNodeSourceConfiguration build() {
            return new PromptFlowNodeSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PromptFlowNodeSourceConfiguration#type()
     */
    public enum Type {
        INLINE,

        RESOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
