/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a variant of the prompt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptVariant implements SdkPojo, Serializable, ToCopyableBuilder<PromptVariant.Builder, PromptVariant> {
    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<PromptInferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(PromptVariant::inferenceConfiguration)).setter(setter(Builder::inferenceConfiguration))
            .constructor(PromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final SdkField<List<PromptMetadataEntry>> METADATA_FIELD = SdkField
            .<List<PromptMetadataEntry>> builder(MarshallingType.LIST)
            .memberName("metadata")
            .getter(getter(PromptVariant::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptMetadataEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptMetadataEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(PromptVariant::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PromptVariant::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<PromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("templateConfiguration")
            .getter(getter(PromptVariant::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(PromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build())
            .build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(PromptVariant::templateTypeAsString)).setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_CONFIGURATION_FIELD,
            METADATA_FIELD, MODEL_ID_FIELD, NAME_FIELD, TEMPLATE_CONFIGURATION_FIELD, TEMPLATE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PromptInferenceConfiguration inferenceConfiguration;

    private final List<PromptMetadataEntry> metadata;

    private final String modelId;

    private final String name;

    private final PromptTemplateConfiguration templateConfiguration;

    private final String templateType;

    private PromptVariant(BuilderImpl builder) {
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.metadata = builder.metadata;
        this.modelId = builder.modelId;
        this.name = builder.name;
        this.templateConfiguration = builder.templateConfiguration;
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * Contains inference configurations for the prompt variant.
     * </p>
     * 
     * @return Contains inference configurations for the prompt variant.
     */
    public final PromptInferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each containing a key-value pair that defines a metadata tag and value to attach to a prompt
     * variant. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt using
     * Prompt management</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return An array of objects, each containing a key-value pair that defines a metadata tag and value to attach to
     *         a prompt variant. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt
     *         using Prompt management</a>.
     */
    public final List<PromptMetadataEntry> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The unique identifier of the model with which to run inference on the prompt.
     * </p>
     * 
     * @return The unique identifier of the model with which to run inference on the prompt.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The name of the prompt variant.
     * </p>
     * 
     * @return The name of the prompt variant.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Contains configurations for the prompt template.
     * </p>
     * 
     * @return Contains configurations for the prompt template.
     */
    public final PromptTemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The type of prompt template to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link PromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of prompt template to use.
     * @see PromptTemplateType
     */
    public final PromptTemplateType templateType() {
        return PromptTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of prompt template to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link PromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of prompt template to use.
     * @see PromptTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptVariant)) {
            return false;
        }
        PromptVariant other = (PromptVariant) obj;
        return Objects.equals(inferenceConfiguration(), other.inferenceConfiguration()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(name(), other.name()) && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptVariant").add("InferenceConfiguration", inferenceConfiguration())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").add("ModelId", modelId())
                .add("Name", name()).add("TemplateConfiguration", templateConfiguration())
                .add("TemplateType", templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "templateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptVariant, T> g) {
        return obj -> g.apply((PromptVariant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptVariant> {
        /**
         * <p>
         * Contains inference configurations for the prompt variant.
         * </p>
         * 
         * @param inferenceConfiguration
         *        Contains inference configurations for the prompt variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration);

        /**
         * <p>
         * Contains inference configurations for the prompt variant.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptInferenceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceConfiguration(PromptInferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link PromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(PromptInferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<PromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(PromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        /**
         * <p>
         * An array of objects, each containing a key-value pair that defines a metadata tag and value to attach to a
         * prompt variant. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt
         * using Prompt management</a>.
         * </p>
         * 
         * @param metadata
         *        An array of objects, each containing a key-value pair that defines a metadata tag and value to attach
         *        to a prompt variant. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a
         *        prompt using Prompt management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<PromptMetadataEntry> metadata);

        /**
         * <p>
         * An array of objects, each containing a key-value pair that defines a metadata tag and value to attach to a
         * prompt variant. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt
         * using Prompt management</a>.
         * </p>
         * 
         * @param metadata
         *        An array of objects, each containing a key-value pair that defines a metadata tag and value to attach
         *        to a prompt variant. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a
         *        prompt using Prompt management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(PromptMetadataEntry... metadata);

        /**
         * <p>
         * An array of objects, each containing a key-value pair that defines a metadata tag and value to attach to a
         * prompt variant. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt
         * using Prompt management</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptMetadataEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptMetadataEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptMetadataEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(List<PromptMetadataEntry>)}.
         * 
         * @param metadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.PromptMetadataEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(java.util.Collection<PromptMetadataEntry>)
         */
        Builder metadata(Consumer<PromptMetadataEntry.Builder>... metadata);

        /**
         * <p>
         * The unique identifier of the model with which to run inference on the prompt.
         * </p>
         * 
         * @param modelId
         *        The unique identifier of the model with which to run inference on the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The name of the prompt variant.
         * </p>
         * 
         * @param name
         *        The name of the prompt variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains configurations for the prompt template.
         * </p>
         * 
         * @param templateConfiguration
         *        Contains configurations for the prompt template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(PromptTemplateConfiguration templateConfiguration);

        /**
         * <p>
         * Contains configurations for the prompt template.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #templateConfiguration(PromptTemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link PromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(PromptTemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<PromptTemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(PromptTemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The type of prompt template to use.
         * </p>
         * 
         * @param templateType
         *        The type of prompt template to use.
         * @see PromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of prompt template to use.
         * </p>
         * 
         * @param templateType
         *        The type of prompt template to use.
         * @see PromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptTemplateType
         */
        Builder templateType(PromptTemplateType templateType);
    }

    static final class BuilderImpl implements Builder {
        private PromptInferenceConfiguration inferenceConfiguration;

        private List<PromptMetadataEntry> metadata = DefaultSdkAutoConstructList.getInstance();

        private String modelId;

        private String name;

        private PromptTemplateConfiguration templateConfiguration;

        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptVariant model) {
            inferenceConfiguration(model.inferenceConfiguration);
            metadata(model.metadata);
            modelId(model.modelId);
            name(model.name);
            templateConfiguration(model.templateConfiguration);
            templateType(model.templateType);
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(PromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final List<PromptMetadataEntry.Builder> getMetadata() {
            List<PromptMetadataEntry.Builder> result = PromptMetadataListCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadata(Collection<PromptMetadataEntry.BuilderImpl> metadata) {
            this.metadata = PromptMetadataListCopier.copyFromBuilder(metadata);
        }

        @Override
        public final Builder metadata(Collection<PromptMetadataEntry> metadata) {
            this.metadata = PromptMetadataListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(PromptMetadataEntry... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Consumer<PromptMetadataEntry.Builder>... metadata) {
            metadata(Stream.of(metadata).map(c -> PromptMetadataEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(PromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(PromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(PromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public PromptVariant build() {
            return new PromptVariant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
