/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePromptResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<UpdatePromptResponse.Builder, UpdatePromptResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdatePromptResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdatePromptResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(UpdatePromptResponse::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<String> DEFAULT_VARIANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultVariant").getter(getter(UpdatePromptResponse::defaultVariant))
            .setter(setter(Builder::defaultVariant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariant").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdatePromptResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdatePromptResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdatePromptResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdatePromptResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<PromptVariant>> VARIANTS_FIELD = SdkField
            .<List<PromptVariant>> builder(MarshallingType.LIST)
            .memberName("variants")
            .getter(getter(UpdatePromptResponse::variants))
            .setter(setter(Builder::variants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptVariant> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptVariant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(UpdatePromptResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFAULT_VARIANT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, UPDATED_AT_FIELD,
            VARIANTS_FIELD, VERSION_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final String customerEncryptionKeyArn;

    private final String defaultVariant;

    private final String description;

    private final String id;

    private final String name;

    private final Instant updatedAt;

    private final List<PromptVariant> variants;

    private final String version;

    private UpdatePromptResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.defaultVariant = builder.defaultVariant;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.updatedAt = builder.updatedAt;
        this.variants = builder.variants;
        this.version = builder.version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the prompt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the prompt.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the prompt was created.
     * </p>
     * 
     * @return The time at which the prompt was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * The name of the default variant for the prompt. This value must match the <code>name</code> field in the relevant
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a>
     * object.
     * </p>
     * 
     * @return The name of the default variant for the prompt. This value must match the <code>name</code> field in the
     *         relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">
     *         PromptVariant</a> object.
     */
    public final String defaultVariant() {
        return defaultVariant;
    }

    /**
     * <p>
     * The description of the prompt.
     * </p>
     * 
     * @return The description of the prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the prompt.
     * </p>
     * 
     * @return The unique identifier of the prompt.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the prompt.
     * </p>
     * 
     * @return The name of the prompt.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time at which the prompt was last updated.
     * </p>
     * 
     * @return The time at which the prompt was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variants property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariants() {
        return variants != null && !(variants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each containing details about a variant of the prompt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariants} method.
     * </p>
     * 
     * @return A list of objects, each containing details about a variant of the prompt.
     */
    public final List<PromptVariant> variants() {
        return variants;
    }

    /**
     * <p>
     * The version of the prompt. When you update a prompt, the version updated is the <code>DRAFT</code> version.
     * </p>
     * 
     * @return The version of the prompt. When you update a prompt, the version updated is the <code>DRAFT</code>
     *         version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVariant());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariants() ? variants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePromptResponse)) {
            return false;
        }
        UpdatePromptResponse other = (UpdatePromptResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(defaultVariant(), other.defaultVariant()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasVariants() == other.hasVariants()
                && Objects.equals(variants(), other.variants()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePromptResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn()).add("DefaultVariant", defaultVariant())
                .add("Description", description()).add("Id", id()).add("Name", name()).add("UpdatedAt", updatedAt())
                .add("Variants", variants() == null ? null : "*** Sensitive Data Redacted ***").add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "defaultVariant":
            return Optional.ofNullable(clazz.cast(defaultVariant()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "variants":
            return Optional.ofNullable(clazz.cast(variants()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePromptResponse, T> g) {
        return obj -> g.apply((UpdatePromptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePromptResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the prompt.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the prompt was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the prompt was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * The name of the default variant for the prompt. This value must match the <code>name</code> field in the
         * relevant <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a>
         * object.
         * </p>
         * 
         * @param defaultVariant
         *        The name of the default variant for the prompt. This value must match the <code>name</code> field in
         *        the relevant <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html"
         *        >PromptVariant</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVariant(String defaultVariant);

        /**
         * <p>
         * The description of the prompt.
         * </p>
         * 
         * @param description
         *        The description of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the prompt.
         * </p>
         * 
         * @param id
         *        The unique identifier of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the prompt.
         * </p>
         * 
         * @param name
         *        The name of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time at which the prompt was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the prompt was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A list of objects, each containing details about a variant of the prompt.
         * </p>
         * 
         * @param variants
         *        A list of objects, each containing details about a variant of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variants(Collection<PromptVariant> variants);

        /**
         * <p>
         * A list of objects, each containing details about a variant of the prompt.
         * </p>
         * 
         * @param variants
         *        A list of objects, each containing details about a variant of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variants(PromptVariant... variants);

        /**
         * <p>
         * A list of objects, each containing details about a variant of the prompt.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptVariant.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.PromptVariant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptVariant.Builder#build()} is called
         * immediately and its result is passed to {@link #variants(List<PromptVariant>)}.
         * 
         * @param variants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.PromptVariant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variants(java.util.Collection<PromptVariant>)
         */
        Builder variants(Consumer<PromptVariant.Builder>... variants);

        /**
         * <p>
         * The version of the prompt. When you update a prompt, the version updated is the <code>DRAFT</code> version.
         * </p>
         * 
         * @param version
         *        The version of the prompt. When you update a prompt, the version updated is the <code>DRAFT</code>
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String customerEncryptionKeyArn;

        private String defaultVariant;

        private String description;

        private String id;

        private String name;

        private Instant updatedAt;

        private List<PromptVariant> variants = DefaultSdkAutoConstructList.getInstance();

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePromptResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            defaultVariant(model.defaultVariant);
            description(model.description);
            id(model.id);
            name(model.name);
            updatedAt(model.updatedAt);
            variants(model.variants);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDefaultVariant() {
            return defaultVariant;
        }

        public final void setDefaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
        }

        @Override
        public final Builder defaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<PromptVariant.Builder> getVariants() {
            List<PromptVariant.Builder> result = PromptVariantListCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<PromptVariant.BuilderImpl> variants) {
            this.variants = PromptVariantListCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<PromptVariant> variants) {
            this.variants = PromptVariantListCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(PromptVariant... variants) {
            variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<PromptVariant.Builder>... variants) {
            variants(Stream.of(variants).map(c -> PromptVariant.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public UpdatePromptResponse build() {
            return new UpdatePromptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
