/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about how to ingest the documents in a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorIngestionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorIngestionConfiguration.Builder, VectorIngestionConfiguration> {
    private static final SdkField<ChunkingConfiguration> CHUNKING_CONFIGURATION_FIELD = SdkField
            .<ChunkingConfiguration> builder(MarshallingType.SDK_POJO).memberName("chunkingConfiguration")
            .getter(getter(VectorIngestionConfiguration::chunkingConfiguration)).setter(setter(Builder::chunkingConfiguration))
            .constructor(ChunkingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chunkingConfiguration").build())
            .build();

    private static final SdkField<CustomTransformationConfiguration> CUSTOM_TRANSFORMATION_CONFIGURATION_FIELD = SdkField
            .<CustomTransformationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("customTransformationConfiguration")
            .getter(getter(VectorIngestionConfiguration::customTransformationConfiguration))
            .setter(setter(Builder::customTransformationConfiguration))
            .constructor(CustomTransformationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customTransformationConfiguration")
                    .build()).build();

    private static final SdkField<ParsingConfiguration> PARSING_CONFIGURATION_FIELD = SdkField
            .<ParsingConfiguration> builder(MarshallingType.SDK_POJO).memberName("parsingConfiguration")
            .getter(getter(VectorIngestionConfiguration::parsingConfiguration)).setter(setter(Builder::parsingConfiguration))
            .constructor(ParsingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNKING_CONFIGURATION_FIELD,
            CUSTOM_TRANSFORMATION_CONFIGURATION_FIELD, PARSING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ChunkingConfiguration chunkingConfiguration;

    private final CustomTransformationConfiguration customTransformationConfiguration;

    private final ParsingConfiguration parsingConfiguration;

    private VectorIngestionConfiguration(BuilderImpl builder) {
        this.chunkingConfiguration = builder.chunkingConfiguration;
        this.customTransformationConfiguration = builder.customTransformationConfiguration;
        this.parsingConfiguration = builder.parsingConfiguration;
    }

    /**
     * <p>
     * Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from a data
     * source that is returned when the knowledge base that it belongs to is queried.
     * </p>
     * 
     * @return Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from a
     *         data source that is returned when the knowledge base that it belongs to is queried.
     */
    public final ChunkingConfiguration chunkingConfiguration() {
        return chunkingConfiguration;
    }

    /**
     * <p>
     * A custom document transformer for parsed data source documents.
     * </p>
     * 
     * @return A custom document transformer for parsed data source documents.
     */
    public final CustomTransformationConfiguration customTransformationConfiguration() {
        return customTransformationConfiguration;
    }

    /**
     * <p>
     * A custom parser for data source documents.
     * </p>
     * 
     * @return A custom parser for data source documents.
     */
    public final ParsingConfiguration parsingConfiguration() {
        return parsingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chunkingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customTransformationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parsingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorIngestionConfiguration)) {
            return false;
        }
        VectorIngestionConfiguration other = (VectorIngestionConfiguration) obj;
        return Objects.equals(chunkingConfiguration(), other.chunkingConfiguration())
                && Objects.equals(customTransformationConfiguration(), other.customTransformationConfiguration())
                && Objects.equals(parsingConfiguration(), other.parsingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorIngestionConfiguration").add("ChunkingConfiguration", chunkingConfiguration())
                .add("CustomTransformationConfiguration", customTransformationConfiguration())
                .add("ParsingConfiguration", parsingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chunkingConfiguration":
            return Optional.ofNullable(clazz.cast(chunkingConfiguration()));
        case "customTransformationConfiguration":
            return Optional.ofNullable(clazz.cast(customTransformationConfiguration()));
        case "parsingConfiguration":
            return Optional.ofNullable(clazz.cast(parsingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VectorIngestionConfiguration, T> g) {
        return obj -> g.apply((VectorIngestionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorIngestionConfiguration> {
        /**
         * <p>
         * Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from a data
         * source that is returned when the knowledge base that it belongs to is queried.
         * </p>
         * 
         * @param chunkingConfiguration
         *        Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from
         *        a data source that is returned when the knowledge base that it belongs to is queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkingConfiguration(ChunkingConfiguration chunkingConfiguration);

        /**
         * <p>
         * Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from a data
         * source that is returned when the knowledge base that it belongs to is queried.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChunkingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ChunkingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChunkingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #chunkingConfiguration(ChunkingConfiguration)}.
         * 
         * @param chunkingConfiguration
         *        a consumer that will call methods on {@link ChunkingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chunkingConfiguration(ChunkingConfiguration)
         */
        default Builder chunkingConfiguration(Consumer<ChunkingConfiguration.Builder> chunkingConfiguration) {
            return chunkingConfiguration(ChunkingConfiguration.builder().applyMutation(chunkingConfiguration).build());
        }

        /**
         * <p>
         * A custom document transformer for parsed data source documents.
         * </p>
         * 
         * @param customTransformationConfiguration
         *        A custom document transformer for parsed data source documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customTransformationConfiguration(CustomTransformationConfiguration customTransformationConfiguration);

        /**
         * <p>
         * A custom document transformer for parsed data source documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomTransformationConfiguration.Builder} avoiding the need to create one manually via
         * {@link CustomTransformationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomTransformationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customTransformationConfiguration(CustomTransformationConfiguration)}.
         * 
         * @param customTransformationConfiguration
         *        a consumer that will call methods on {@link CustomTransformationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customTransformationConfiguration(CustomTransformationConfiguration)
         */
        default Builder customTransformationConfiguration(
                Consumer<CustomTransformationConfiguration.Builder> customTransformationConfiguration) {
            return customTransformationConfiguration(CustomTransformationConfiguration.builder()
                    .applyMutation(customTransformationConfiguration).build());
        }

        /**
         * <p>
         * A custom parser for data source documents.
         * </p>
         * 
         * @param parsingConfiguration
         *        A custom parser for data source documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsingConfiguration(ParsingConfiguration parsingConfiguration);

        /**
         * <p>
         * A custom parser for data source documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParsingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ParsingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParsingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #parsingConfiguration(ParsingConfiguration)}.
         * 
         * @param parsingConfiguration
         *        a consumer that will call methods on {@link ParsingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parsingConfiguration(ParsingConfiguration)
         */
        default Builder parsingConfiguration(Consumer<ParsingConfiguration.Builder> parsingConfiguration) {
            return parsingConfiguration(ParsingConfiguration.builder().applyMutation(parsingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChunkingConfiguration chunkingConfiguration;

        private CustomTransformationConfiguration customTransformationConfiguration;

        private ParsingConfiguration parsingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorIngestionConfiguration model) {
            chunkingConfiguration(model.chunkingConfiguration);
            customTransformationConfiguration(model.customTransformationConfiguration);
            parsingConfiguration(model.parsingConfiguration);
        }

        public final ChunkingConfiguration.Builder getChunkingConfiguration() {
            return chunkingConfiguration != null ? chunkingConfiguration.toBuilder() : null;
        }

        public final void setChunkingConfiguration(ChunkingConfiguration.BuilderImpl chunkingConfiguration) {
            this.chunkingConfiguration = chunkingConfiguration != null ? chunkingConfiguration.build() : null;
        }

        @Override
        public final Builder chunkingConfiguration(ChunkingConfiguration chunkingConfiguration) {
            this.chunkingConfiguration = chunkingConfiguration;
            return this;
        }

        public final CustomTransformationConfiguration.Builder getCustomTransformationConfiguration() {
            return customTransformationConfiguration != null ? customTransformationConfiguration.toBuilder() : null;
        }

        public final void setCustomTransformationConfiguration(
                CustomTransformationConfiguration.BuilderImpl customTransformationConfiguration) {
            this.customTransformationConfiguration = customTransformationConfiguration != null ? customTransformationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder customTransformationConfiguration(CustomTransformationConfiguration customTransformationConfiguration) {
            this.customTransformationConfiguration = customTransformationConfiguration;
            return this;
        }

        public final ParsingConfiguration.Builder getParsingConfiguration() {
            return parsingConfiguration != null ? parsingConfiguration.toBuilder() : null;
        }

        public final void setParsingConfiguration(ParsingConfiguration.BuilderImpl parsingConfiguration) {
            this.parsingConfiguration = parsingConfiguration != null ? parsingConfiguration.build() : null;
        }

        @Override
        public final Builder parsingConfiguration(ParsingConfiguration parsingConfiguration) {
            this.parsingConfiguration = parsingConfiguration;
            return this;
        }

        @Override
        public VectorIngestionConfiguration build() {
            return new VectorIngestionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
