/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.Message;
import software.amazon.awssdk.services.bedrockagent.model.MessagesCopier;
import software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable;
import software.amazon.awssdk.services.bedrockagent.model.PromptInputVariablesListCopier;
import software.amazon.awssdk.services.bedrockagent.model.SystemContentBlock;
import software.amazon.awssdk.services.bedrockagent.model.SystemContentBlocksCopier;
import software.amazon.awssdk.services.bedrockagent.model.ToolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatPromptTemplateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatPromptTemplateConfiguration> {
    private static final SdkField<List<PromptInputVariable>> INPUT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputVariables").getter(ChatPromptTemplateConfiguration.getter(ChatPromptTemplateConfiguration::inputVariables)).setter(ChatPromptTemplateConfiguration.setter(Builder::inputVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptInputVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(ChatPromptTemplateConfiguration.getter(ChatPromptTemplateConfiguration::messages)).setter(ChatPromptTemplateConfiguration.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("system").getter(ChatPromptTemplateConfiguration.getter(ChatPromptTemplateConfiguration::system)).setter(ChatPromptTemplateConfiguration.setter(Builder::system)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ToolConfiguration> TOOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolConfiguration").getter(ChatPromptTemplateConfiguration.getter(ChatPromptTemplateConfiguration::toolConfiguration)).setter(ChatPromptTemplateConfiguration.setter(Builder::toolConfiguration)).constructor(ToolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_VARIABLES_FIELD, MESSAGES_FIELD, SYSTEM_FIELD, TOOL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputVariables", INPUT_VARIABLES_FIELD);
            this.put("messages", MESSAGES_FIELD);
            this.put("system", SYSTEM_FIELD);
            this.put("toolConfiguration", TOOL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<PromptInputVariable> inputVariables;
    private final List<Message> messages;
    private final List<SystemContentBlock> system;
    private final ToolConfiguration toolConfiguration;

    private ChatPromptTemplateConfiguration(BuilderImpl builder) {
        this.inputVariables = builder.inputVariables;
        this.messages = builder.messages;
        this.system = builder.system;
        this.toolConfiguration = builder.toolConfiguration;
    }

    public final boolean hasInputVariables() {
        return this.inputVariables != null && !(this.inputVariables instanceof SdkAutoConstructList);
    }

    public final List<PromptInputVariable> inputVariables() {
        return this.inputVariables;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final boolean hasSystem() {
        return this.system != null && !(this.system instanceof SdkAutoConstructList);
    }

    public final List<SystemContentBlock> system() {
        return this.system;
    }

    public final ToolConfiguration toolConfiguration() {
        return this.toolConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputVariables() ? this.inputVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystem() ? this.system() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toolConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatPromptTemplateConfiguration)) {
            return false;
        }
        ChatPromptTemplateConfiguration other = (ChatPromptTemplateConfiguration)obj;
        return this.hasInputVariables() == other.hasInputVariables() && Objects.equals(this.inputVariables(), other.inputVariables()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && this.hasSystem() == other.hasSystem() && Objects.equals(this.system(), other.system()) && Objects.equals(this.toolConfiguration(), other.toolConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ChatPromptTemplateConfiguration").add("InputVariables", (Object)(this.inputVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("Messages", this.hasMessages() ? this.messages() : null).add("System", (Object)(this.system() == null ? null : "*** Sensitive Data Redacted ***")).add("ToolConfiguration", (Object)this.toolConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputVariables": {
                return Optional.ofNullable(clazz.cast(this.inputVariables()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "system": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
            case "toolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.toolConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChatPromptTemplateConfiguration, T> g) {
        return obj -> g.apply((ChatPromptTemplateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PromptInputVariable> inputVariables = DefaultSdkAutoConstructList.getInstance();
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();
        private ToolConfiguration toolConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatPromptTemplateConfiguration model) {
            this.inputVariables(model.inputVariables);
            this.messages(model.messages);
            this.system(model.system);
            this.toolConfiguration(model.toolConfiguration);
        }

        public final List<PromptInputVariable.Builder> getInputVariables() {
            List<PromptInputVariable.Builder> result = PromptInputVariablesListCopier.copyToBuilder(this.inputVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputVariables(Collection<PromptInputVariable.BuilderImpl> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copyFromBuilder(inputVariables);
        }

        @Override
        public final Builder inputVariables(Collection<PromptInputVariable> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copy(inputVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(PromptInputVariable ... inputVariables) {
            this.inputVariables(Arrays.asList(inputVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(Consumer<PromptInputVariable.Builder> ... inputVariables) {
            this.inputVariables(Stream.of(inputVariables).map(c -> (PromptInputVariable)((PromptInputVariable.Builder)PromptInputVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock ... system) {
            this.system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder> ... system) {
            this.system(Stream.of(system).map(c -> (SystemContentBlock)((SystemContentBlock.Builder)SystemContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolConfiguration.Builder getToolConfiguration() {
            return this.toolConfiguration != null ? this.toolConfiguration.toBuilder() : null;
        }

        public final void setToolConfiguration(ToolConfiguration.BuilderImpl toolConfiguration) {
            this.toolConfiguration = toolConfiguration != null ? toolConfiguration.build() : null;
        }

        @Override
        public final Builder toolConfiguration(ToolConfiguration toolConfiguration) {
            this.toolConfiguration = toolConfiguration;
            return this;
        }

        public ChatPromptTemplateConfiguration build() {
            return new ChatPromptTemplateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatPromptTemplateConfiguration> {
        public Builder inputVariables(Collection<PromptInputVariable> var1);

        public Builder inputVariables(PromptInputVariable ... var1);

        public Builder inputVariables(Consumer<PromptInputVariable.Builder> ... var1);

        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder system(Collection<SystemContentBlock> var1);

        public Builder system(SystemContentBlock ... var1);

        public Builder system(Consumer<SystemContentBlock.Builder> ... var1);

        public Builder toolConfiguration(ToolConfiguration var1);

        default public Builder toolConfiguration(Consumer<ToolConfiguration.Builder> toolConfiguration) {
            return this.toolConfiguration((ToolConfiguration)((ToolConfiguration.Builder)ToolConfiguration.builder().applyMutation(toolConfiguration)).build());
        }
    }
}

