/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.RetrievalFlowNodeS3Configuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievalFlowNodeServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievalFlowNodeServiceConfiguration> {
    private static final SdkField<RetrievalFlowNodeS3Configuration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(RetrievalFlowNodeServiceConfiguration.getter(RetrievalFlowNodeServiceConfiguration::s3)).setter(RetrievalFlowNodeServiceConfiguration.setter(Builder::s3)).constructor(RetrievalFlowNodeS3Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3", S3_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RetrievalFlowNodeS3Configuration s3;
    private final Type type;

    private RetrievalFlowNodeServiceConfiguration(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    public final RetrievalFlowNodeS3Configuration s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalFlowNodeServiceConfiguration)) {
            return false;
        }
        RetrievalFlowNodeServiceConfiguration other = (RetrievalFlowNodeServiceConfiguration)obj;
        return Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievalFlowNodeServiceConfiguration").add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public static RetrievalFlowNodeServiceConfiguration fromS3(RetrievalFlowNodeS3Configuration s3) {
        return (RetrievalFlowNodeServiceConfiguration)RetrievalFlowNodeServiceConfiguration.builder().s3(s3).build();
    }

    public static RetrievalFlowNodeServiceConfiguration fromS3(Consumer<RetrievalFlowNodeS3Configuration.Builder> s3) {
        RetrievalFlowNodeS3Configuration.Builder builder = RetrievalFlowNodeS3Configuration.builder();
        s3.accept(builder);
        return RetrievalFlowNodeServiceConfiguration.fromS3((RetrievalFlowNodeS3Configuration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalFlowNodeServiceConfiguration, T> g) {
        return obj -> g.apply((RetrievalFlowNodeServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RetrievalFlowNodeS3Configuration s3;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalFlowNodeServiceConfiguration model) {
            this.s3(model.s3);
        }

        public final RetrievalFlowNodeS3Configuration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(RetrievalFlowNodeS3Configuration.BuilderImpl s3) {
            RetrievalFlowNodeS3Configuration oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(RetrievalFlowNodeS3Configuration s3) {
            RetrievalFlowNodeS3Configuration oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public RetrievalFlowNodeServiceConfiguration build() {
            return new RetrievalFlowNodeServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievalFlowNodeServiceConfiguration> {
        public Builder s3(RetrievalFlowNodeS3Configuration var1);

        default public Builder s3(Consumer<RetrievalFlowNodeS3Configuration.Builder> s3) {
            return this.s3((RetrievalFlowNodeS3Configuration)((RetrievalFlowNodeS3Configuration.Builder)RetrievalFlowNodeS3Configuration.builder().applyMutation(s3)).build());
        }
    }
}

