/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.FlowDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateFlowRequest> {
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(UpdateFlowRequest.getter(UpdateFlowRequest::customerEncryptionKeyArn)).setter(UpdateFlowRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<FlowDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(UpdateFlowRequest.getter(UpdateFlowRequest::definition)).setter(UpdateFlowRequest.setter(Builder::definition)).constructor(FlowDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFlowRequest.getter(UpdateFlowRequest::description)).setter(UpdateFlowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(UpdateFlowRequest.getter(UpdateFlowRequest::executionRoleArn)).setter(UpdateFlowRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(UpdateFlowRequest.getter(UpdateFlowRequest::flowIdentifier)).setter(UpdateFlowRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateFlowRequest.getter(UpdateFlowRequest::name)).setter(UpdateFlowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_ARN_FIELD, FLOW_IDENTIFIER_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
            this.put("definition", DEFINITION_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private final String customerEncryptionKeyArn;
    private final FlowDefinition definition;
    private final String description;
    private final String executionRoleArn;
    private final String flowIdentifier;
    private final String name;

    private UpdateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.definition = builder.definition;
        this.description = builder.description;
        this.executionRoleArn = builder.executionRoleArn;
        this.flowIdentifier = builder.flowIdentifier;
        this.name = builder.name;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final FlowDefinition definition() {
        return this.definition;
    }

    public final String description() {
        return this.description;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowRequest)) {
            return false;
        }
        UpdateFlowRequest other = (UpdateFlowRequest)((Object)obj);
        return Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowRequest").add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)this.description()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowRequest, T> g) {
        return obj -> g.apply((UpdateFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String customerEncryptionKeyArn;
        private FlowDefinition definition;
        private String description;
        private String executionRoleArn;
        private String flowIdentifier;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowRequest model) {
            super(model);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.definition(model.definition);
            this.description(model.description);
            this.executionRoleArn(model.executionRoleArn);
            this.flowIdentifier(model.flowIdentifier);
            this.name(model.name);
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final FlowDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(FlowDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(FlowDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowRequest build() {
            return new UpdateFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowRequest> {
        public Builder customerEncryptionKeyArn(String var1);

        public Builder definition(FlowDefinition var1);

        default public Builder definition(Consumer<FlowDefinition.Builder> definition) {
            return this.definition((FlowDefinition)((FlowDefinition.Builder)FlowDefinition.builder().applyMutation(definition)).build());
        }

        public Builder description(String var1);

        public Builder executionRoleArn(String var1);

        public Builder flowIdentifier(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

