/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse;

public class ListAgentAliasesPublisher
implements SdkPublisher<ListAgentAliasesResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListAgentAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentAliasesPublisher(BedrockAgentAsyncClient client, ListAgentAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentAliasesPublisher(BedrockAgentAsyncClient client, ListAgentAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentAliasSummary> agentAliasSummaries() {
        Function<ListAgentAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentAliasSummaries() != null) {
                return response.agentAliasSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentAliasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentAliasesResponseFetcher
    implements AsyncPageFetcher<ListAgentAliasesResponse> {
        private ListAgentAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentAliasesResponse> nextPage(ListAgentAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentAliasesPublisher.this.client.listAgentAliases(ListAgentAliasesPublisher.this.firstRequest);
            }
            return ListAgentAliasesPublisher.this.client.listAgentAliases((ListAgentAliasesRequest)((Object)ListAgentAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

