/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AgentSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.AgentSummary;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListAgentsResponse> {
    private static final SdkField<List<AgentSummary>> AGENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentSummaries").getter(ListAgentsResponse.getter(ListAgentsResponse::agentSummaries)).setter(ListAgentsResponse.setter(Builder::agentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAgentsResponse.getter(ListAgentsResponse::nextToken)).setter(ListAgentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAgentsResponse.memberNameToFieldInitializer();
    private final List<AgentSummary> agentSummaries;
    private final String nextToken;

    private ListAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agentSummaries = builder.agentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAgentSummaries() {
        return this.agentSummaries != null && !(this.agentSummaries instanceof SdkAutoConstructList);
    }

    public final List<AgentSummary> agentSummaries() {
        return this.agentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentSummaries() ? this.agentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentsResponse)) {
            return false;
        }
        ListAgentsResponse other = (ListAgentsResponse)((Object)obj);
        return this.hasAgentSummaries() == other.hasAgentSummaries() && Objects.equals(this.agentSummaries(), other.agentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgentsResponse").add("AgentSummaries", this.hasAgentSummaries() ? this.agentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentSummaries": {
                return Optional.ofNullable(clazz.cast(this.agentSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentSummaries", AGENT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentsResponse, T> g) {
        return obj -> g.apply((ListAgentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<AgentSummary> agentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentsResponse model) {
            super(model);
            this.agentSummaries(model.agentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AgentSummary.Builder> getAgentSummaries() {
            List<AgentSummary.Builder> result = AgentSummariesCopier.copyToBuilder(this.agentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentSummaries(Collection<AgentSummary.BuilderImpl> agentSummaries) {
            this.agentSummaries = AgentSummariesCopier.copyFromBuilder(agentSummaries);
        }

        @Override
        public final Builder agentSummaries(Collection<AgentSummary> agentSummaries) {
            this.agentSummaries = AgentSummariesCopier.copy(agentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentSummaries(AgentSummary ... agentSummaries) {
            this.agentSummaries(Arrays.asList(agentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentSummaries(Consumer<AgentSummary.Builder> ... agentSummaries) {
            this.agentSummaries(Stream.of(agentSummaries).map(c -> (AgentSummary)((AgentSummary.Builder)AgentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentsResponse build() {
            return new ListAgentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentsResponse> {
        public Builder agentSummaries(Collection<AgentSummary> var1);

        public Builder agentSummaries(AgentSummary ... var1);

        public Builder agentSummaries(Consumer<AgentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

