/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.SeedUrl;
import software.amazon.awssdk.services.bedrockagent.model.SeedUrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UrlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UrlConfiguration> {
    private static final SdkField<List<SeedUrl>> SEED_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("seedUrls").getter(UrlConfiguration.getter(UrlConfiguration::seedUrls)).setter(UrlConfiguration.setter(Builder::seedUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SeedUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_URLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UrlConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SeedUrl> seedUrls;

    private UrlConfiguration(BuilderImpl builder) {
        this.seedUrls = builder.seedUrls;
    }

    public final boolean hasSeedUrls() {
        return this.seedUrls != null && !(this.seedUrls instanceof SdkAutoConstructList);
    }

    public final List<SeedUrl> seedUrls() {
        return this.seedUrls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeedUrls() ? this.seedUrls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UrlConfiguration)) {
            return false;
        }
        UrlConfiguration other = (UrlConfiguration)obj;
        return this.hasSeedUrls() == other.hasSeedUrls() && Objects.equals(this.seedUrls(), other.seedUrls());
    }

    public final String toString() {
        return ToString.builder((String)"UrlConfiguration").add("SeedUrls", this.hasSeedUrls() ? this.seedUrls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "seedUrls": {
                return Optional.ofNullable(clazz.cast(this.seedUrls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SeedUrl>>> map = new HashMap<String, SdkField<List<SeedUrl>>>();
        map.put("seedUrls", SEED_URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UrlConfiguration, T> g) {
        return obj -> g.apply((UrlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SeedUrl> seedUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UrlConfiguration model) {
            this.seedUrls(model.seedUrls);
        }

        public final List<SeedUrl.Builder> getSeedUrls() {
            List<SeedUrl.Builder> result = SeedUrlsCopier.copyToBuilder(this.seedUrls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeedUrls(Collection<SeedUrl.BuilderImpl> seedUrls) {
            this.seedUrls = SeedUrlsCopier.copyFromBuilder(seedUrls);
        }

        @Override
        public final Builder seedUrls(Collection<SeedUrl> seedUrls) {
            this.seedUrls = SeedUrlsCopier.copy(seedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder seedUrls(SeedUrl ... seedUrls) {
            this.seedUrls(Arrays.asList(seedUrls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder seedUrls(Consumer<SeedUrl.Builder> ... seedUrls) {
            this.seedUrls(Stream.of(seedUrls).map(c -> (SeedUrl)((SeedUrl.Builder)SeedUrl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UrlConfiguration build() {
            return new UrlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UrlConfiguration> {
        public Builder seedUrls(Collection<SeedUrl> var1);

        public Builder seedUrls(SeedUrl ... var1);

        public Builder seedUrls(Consumer<SeedUrl.Builder> ... var1);
    }
}

