/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentKnowledgeBaseSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentKnowledgeBaseSummary> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentKnowledgeBaseSummary.getter(AgentKnowledgeBaseSummary::description)).setter(AgentKnowledgeBaseSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(AgentKnowledgeBaseSummary.getter(AgentKnowledgeBaseSummary::knowledgeBaseId)).setter(AgentKnowledgeBaseSummary.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseState").getter(AgentKnowledgeBaseSummary.getter(AgentKnowledgeBaseSummary::knowledgeBaseStateAsString)).setter(AgentKnowledgeBaseSummary.setter(Builder::knowledgeBaseState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseState").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AgentKnowledgeBaseSummary.getter(AgentKnowledgeBaseSummary::updatedAt)).setter(AgentKnowledgeBaseSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KNOWLEDGE_BASE_ID_FIELD, KNOWLEDGE_BASE_STATE_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentKnowledgeBaseSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String knowledgeBaseId;
    private final String knowledgeBaseState;
    private final Instant updatedAt;

    private AgentKnowledgeBaseSummary(BuilderImpl builder) {
        this.description = builder.description;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseState = builder.knowledgeBaseState;
        this.updatedAt = builder.updatedAt;
    }

    public final String description() {
        return this.description;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final KnowledgeBaseState knowledgeBaseState() {
        return KnowledgeBaseState.fromValue(this.knowledgeBaseState);
    }

    public final String knowledgeBaseStateAsString() {
        return this.knowledgeBaseState;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentKnowledgeBaseSummary)) {
            return false;
        }
        AgentKnowledgeBaseSummary other = (AgentKnowledgeBaseSummary)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.knowledgeBaseStateAsString(), other.knowledgeBaseStateAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AgentKnowledgeBaseSummary").add("Description", (Object)this.description()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("KnowledgeBaseState", (Object)this.knowledgeBaseStateAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "knowledgeBaseState": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseStateAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseState", KNOWLEDGE_BASE_STATE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentKnowledgeBaseSummary, T> g) {
        return obj -> g.apply((AgentKnowledgeBaseSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String knowledgeBaseId;
        private String knowledgeBaseState;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentKnowledgeBaseSummary model) {
            this.description(model.description);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.knowledgeBaseState(model.knowledgeBaseState);
            this.updatedAt(model.updatedAt);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseState() {
            return this.knowledgeBaseState;
        }

        public final void setKnowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
        }

        @Override
        public final Builder knowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
            return this;
        }

        @Override
        public final Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState) {
            this.knowledgeBaseState(knowledgeBaseState == null ? null : knowledgeBaseState.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public AgentKnowledgeBaseSummary build() {
            return new AgentKnowledgeBaseSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentKnowledgeBaseSummary> {
        public Builder description(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder knowledgeBaseState(String var1);

        public Builder knowledgeBaseState(KnowledgeBaseState var1);

        public Builder updatedAt(Instant var1);
    }
}

