/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.FlowVersionSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowVersionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowVersionsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListFlowVersionsResponse> {
    private static final SdkField<List<FlowVersionSummary>> FLOW_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flowVersionSummaries").getter(ListFlowVersionsResponse.getter(ListFlowVersionsResponse::flowVersionSummaries)).setter(ListFlowVersionsResponse.setter(Builder::flowVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFlowVersionsResponse.getter(ListFlowVersionsResponse::nextToken)).setter(ListFlowVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowVersionsResponse.memberNameToFieldInitializer();
    private final List<FlowVersionSummary> flowVersionSummaries;
    private final String nextToken;

    private ListFlowVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.flowVersionSummaries = builder.flowVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFlowVersionSummaries() {
        return this.flowVersionSummaries != null && !(this.flowVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<FlowVersionSummary> flowVersionSummaries() {
        return this.flowVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowVersionSummaries() ? this.flowVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowVersionsResponse)) {
            return false;
        }
        ListFlowVersionsResponse other = (ListFlowVersionsResponse)((Object)obj);
        return this.hasFlowVersionSummaries() == other.hasFlowVersionSummaries() && Objects.equals(this.flowVersionSummaries(), other.flowVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowVersionsResponse").add("FlowVersionSummaries", this.hasFlowVersionSummaries() ? this.flowVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.flowVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowVersionSummaries", FLOW_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowVersionsResponse, T> g) {
        return obj -> g.apply((ListFlowVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<FlowVersionSummary> flowVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowVersionsResponse model) {
            super(model);
            this.flowVersionSummaries(model.flowVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<FlowVersionSummary.Builder> getFlowVersionSummaries() {
            List<FlowVersionSummary.Builder> result = FlowVersionSummariesCopier.copyToBuilder(this.flowVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowVersionSummaries(Collection<FlowVersionSummary.BuilderImpl> flowVersionSummaries) {
            this.flowVersionSummaries = FlowVersionSummariesCopier.copyFromBuilder(flowVersionSummaries);
        }

        @Override
        public final Builder flowVersionSummaries(Collection<FlowVersionSummary> flowVersionSummaries) {
            this.flowVersionSummaries = FlowVersionSummariesCopier.copy(flowVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowVersionSummaries(FlowVersionSummary ... flowVersionSummaries) {
            this.flowVersionSummaries(Arrays.asList(flowVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowVersionSummaries(Consumer<FlowVersionSummary.Builder> ... flowVersionSummaries) {
            this.flowVersionSummaries(Stream.of(flowVersionSummaries).map(c -> (FlowVersionSummary)((FlowVersionSummary.Builder)FlowVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowVersionsResponse build() {
            return new ListFlowVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowVersionsResponse> {
        public Builder flowVersionSummaries(Collection<FlowVersionSummary> var1);

        public Builder flowVersionSummaries(FlowVersionSummary ... var1);

        public Builder flowVersionSummaries(Consumer<FlowVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

